/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.bundle.commands;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.StringOps$;
import scala.collection.convert.StreamExtensions;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.StreamConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class CommandHelper$ {
    public static final CommandHelper$ MODULE$ = new CommandHelper$();
    private static final String GatlingVersion = ResourceBundle.getBundle("gatling-version").getString("version");
    private static final Path GatlingHome = ((Path)MODULE$.optionEnv("GATLING_HOME").map((Function1 & Serializable)x$1 -> Paths.get(x$1, new String[0])).getOrElse((Function0 & Serializable)() -> {
        Path path;
        try {
            path = Paths.get(MODULE$.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getParent().getParent();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                                            |'GATLING_HOME' environment variable is not set and Gatling couldn't infer it either.\n                                            |Please set the 'GATLING_HOME' environment variable to the root of the Gatling bundle.\n                                            |")));
        }
        return path;
    })).toAbsolutePath();
    private static final List<String> JavaOptsEnvVar;
    private static final Path UserLibDirectory;
    private static final Path DefaultResourcesDirectory;
    private static final Path TargetDirectory;
    private static final Path DefaultBinariesDirectory;
    private static final List<String> GatlingLibs;
    private static final List<String> UserLibs;
    private static final List<String> GatlingConfFiles;

    static {
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("GATLING_HOME is set to ").append(MODULE$.GatlingHome()).toString());
        JavaOptsEnvVar = MODULE$.optionListEnv("JAVA_OPTS");
        UserLibDirectory = MODULE$.GatlingHome().resolve("user-files").resolve("lib");
        DefaultResourcesDirectory = MODULE$.GatlingHome().resolve("user-files").resolve("resources");
        TargetDirectory = MODULE$.GatlingHome().resolve("target");
        DefaultBinariesDirectory = MODULE$.TargetDirectory().resolve("test-classes");
        Path libDirectory = MODULE$.GatlingHome().resolve("lib");
        GatlingLibs = MODULE$.listFiles(libDirectory);
        UserLibs = MODULE$.listFiles(MODULE$.UserLibDirectory());
        Path gatlingConfDirectory = (Path)MODULE$.optionEnv("GATLING_CONF").map((Function1 & Serializable)x$2 -> Paths.get(x$2, new String[0]).toAbsolutePath()).getOrElse((Function0 & Serializable)() -> MODULE$.GatlingHome().resolve("conf"));
        String string = ((Object)gatlingConfDirectory).toString();
        GatlingConfFiles = (List)MODULE$.listFiles(gatlingConfDirectory).$plus$colon((Object)string);
    }

    public String GatlingVersion() {
        return GatlingVersion;
    }

    public Path GatlingHome() {
        return GatlingHome;
    }

    public List<String> JavaOptsEnvVar() {
        return JavaOptsEnvVar;
    }

    public Path UserLibDirectory() {
        return UserLibDirectory;
    }

    public Path DefaultResourcesDirectory() {
        return DefaultResourcesDirectory;
    }

    public Path TargetDirectory() {
        return TargetDirectory;
    }

    public Path DefaultBinariesDirectory() {
        return DefaultBinariesDirectory;
    }

    public List<String> GatlingLibs() {
        return GatlingLibs;
    }

    public List<String> UserLibs() {
        return UserLibs;
    }

    public List<String> GatlingConfFiles() {
        return GatlingConfFiles;
    }

    private Option<String> optionEnv(String env) {
        return scala.sys.package$.MODULE$.env().get((Object)env).map((Function1 & Serializable)x$3 -> x$3.trim()).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4))));
    }

    public List<String> optionListEnv(String env) {
        return (List)this.optionEnv(env).map((Function1 & Serializable)x$5 -> Predef$.MODULE$.wrapRefArray((Object[])x$5.split(" ")).toList()).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
    }

    private List<String> listFiles(Path directory) {
        Predef$.MODULE$.require(Files.isDirectory(directory, new LinkOption[0]), (Function0 & Serializable)() -> new StringBuilder(36).append("Gatling bundle directory ").append(directory).append(" is missing").toString());
        return ((List)StreamConverters$.MODULE$.StreamHasToScala(Files.list(directory)).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.List()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo())).map((Function1 & Serializable)x$6 -> ((Object)x$6.toAbsolutePath()).toString());
    }

    private CommandHelper$() {
    }
}

