/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.bundle.commands;

import io.gatling.bundle.BundleIO$;
import io.gatling.bundle.CommandArguments;
import io.gatling.bundle.CommandLineConstants$;
import io.gatling.bundle.EnterpriseBundlePlugin$;
import io.gatling.bundle.commands.EnterpriseRunCommand$;
import io.gatling.bundle.commands.PackageCommand;
import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.SeveralSimulationClassNamesFoundException;
import io.gatling.plugin.exceptions.SeveralTeamsFoundException;
import io.gatling.plugin.exceptions.SimulationStartException;
import io.gatling.plugin.exceptions.UnsupportedJavaVersionException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.ServerInformation;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationStartResult;
import io.gatling.plugin.model.Team;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005Y<a\u0001E\t\t\u0002MIbAB\u000e\u0012\u0011\u0003\u0019B\u0004C\u0003$\u0003\u0011\u0005Q\u0005C\u0004'\u0003\t\u0007I\u0011A\u0014\t\rA\n\u0001\u0015!\u0003)\u0011\u001d\t\u0014A1A\u0005\u0002\u001dBaAM\u0001!\u0002\u0013Ac!B\u000e\u0012\u0005M\u0019\u0004\u0002\u0003\u001b\b\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011e:!\u0011!Q\u0001\niBQaI\u0004\u0005\u00025Cq!U\u0004C\u0002\u0013%!\u000b\u0003\u0004[\u000f\u0001\u0006Ia\u0015\u0005\u00077\u001e!\ta\u0005/\t\u000b\u0001<A\u0011B1\t\u000b)<A\u0011B6\u0002)\u0015sG/\u001a:qe&\u001cXMU;o\u0007>lW.\u00198e\u0015\t\u00112#\u0001\u0005d_6l\u0017M\u001c3t\u0015\t!R#\u0001\u0004ck:$G.\u001a\u0006\u0003-]\tqaZ1uY&twMC\u0001\u0019\u0003\tIw\u000e\u0005\u0002\u001b\u00035\t\u0011C\u0001\u000bF]R,'\u000f\u001d:jg\u0016\u0014VO\\\"p[6\fg\u000eZ\n\u0003\u0003u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003e\tqa\u0012:pkBLE-F\u0001)!\tIc&D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012aa\u0015;sS:<\u0017\u0001C$s_V\u0004\u0018\n\u001a\u0011\u0002\u0015\u0005\u0013H/\u001b4bGRLE-A\u0006BeRLg-Y2u\u0013\u0012\u00043CA\u0004\u001e\u0003\u0019\u0019wN\u001c4jOB\u0011agN\u0007\u0002'%\u0011\u0001h\u0005\u0002\u0011\u0007>lW.\u00198e\u0003J<W/\\3oiN\fA!\u0019:hgB\u00191h\u0011$\u000f\u0005q\neBA\u001fA\u001b\u0005q$BA %\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002C?\u00059\u0001/Y2lC\u001e,\u0017B\u0001#F\u0005\u0011a\u0015n\u001d;\u000b\u0005\t{\u0002CA$L\u001d\tA\u0015\n\u0005\u0002>?%\u0011!jH\u0001\u0007!J,G-\u001a4\n\u0005=b%B\u0001& )\rqu\n\u0015\t\u00035\u001dAQ\u0001\u000e\u0006A\u0002UBQ!\u000f\u0006A\u0002i\na\u0001\\8hO\u0016\u0014X#A*\u0011\u0005QCV\"A+\u000b\u0005a1&BA,\u0016\u0003\u0019\u0001H.^4j]&\u0011\u0011,\u0016\u0002\r!2,x-\u001b8M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\r\u0011XO\u001c\u000b\u0002;B\u0011aDX\u0005\u0003?~\u0011A!\u00168ji\u0006!Bn\\4De\u0016\fG/\u001a3TS6,H.\u0019;j_:$\"!\u00182\t\u000b\rt\u0001\u0019\u00013\u0002\u0015MLW.\u001e7bi&|g\u000e\u0005\u0002fQ6\taM\u0003\u0002h-\u0006)Qn\u001c3fY&\u0011\u0011N\u001a\u0002\u000b'&lW\u000f\\1uS>t\u0017A\u00077pONKW.\u001e7bi&|gnQ8oM&<WO]1uS>tGcA/mi\")Qn\u0004a\u0001]\u0006a1/[7vY\u0006$\u0018n\u001c8JIB\u0011qN]\u0007\u0002a*\u0011\u0011\u000fL\u0001\u0005kRLG.\u0003\u0002ta\n!Q+V%E\u0011\u0015)x\u00021\u0001G\u0003%\u0019G.Y:t]\u0006lW\r")
public final class EnterpriseRunCommand {
    private final CommandArguments config;
    private final List<String> args;
    private final PluginLogger logger;

    public static String ArtifactId() {
        return EnterpriseRunCommand$.MODULE$.ArtifactId();
    }

    public static String GroupId() {
        return EnterpriseRunCommand$.MODULE$.GroupId();
    }

    private PluginLogger logger() {
        return this.logger;
    }

    public void run() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SimulationStartResult simulationStartResult;
            SimulationStartResult simulationStartResult2;
            EnterpriseClient enterpriseClient = EnterpriseBundlePlugin$.MODULE$.getClient($this.config);
            BatchEnterprisePlugin enterprisePlugin = $this.config.batchMode() ? EnterpriseBundlePlugin$.MODULE$.getBatchEnterprisePlugin(enterpriseClient) : EnterpriseBundlePlugin$.MODULE$.getInteractiveEnterprisePlugin(enterpriseClient);
            ServerInformation serverInformation = enterpriseClient.getServerInformation();
            int maxJavaVersion = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(serverInformation.versions.java.max));
            File file = new PackageCommand($this.config, $this.args, maxJavaVersion, true).run();
            Option<UUID> option = $this.config.simulationId();
            if (option instanceof Some) {
                Some some = (Some)option;
                UUID simulationId = (UUID)some.value();
                simulationStartResult2 = enterprisePlugin.uploadPackageAndStartSimulation(simulationId, CollectionConverters$.MODULE$.MapHasAsJava($this.config.simulationSystemProperties()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava($this.config.simulationEnvironmentVariables()).asJava(), (String)$this.config.simulationClass().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), file);
            } else {
                simulationStartResult2 = simulationStartResult = enterprisePlugin.createAndStartSimulation((UUID)$this.config.teamId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), EnterpriseRunCommand$.MODULE$.GroupId(), EnterpriseRunCommand$.MODULE$.ArtifactId(), (String)$this.config.simulationClass().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (UUID)$this.config.packageId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), CollectionConverters$.MODULE$.MapHasAsJava($this.config.simulationSystemProperties()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava($this.config.simulationEnvironmentVariables()).asJava(), file);
            }
            if (simulationStartResult.createdSimulation) {
                this.io$gatling$bundle$commands$EnterpriseRunCommand$$logCreatedSimulation(simulationStartResult.simulation);
            }
            if ($this.config.simulationId().isEmpty()) {
                this.io$gatling$bundle$commands$EnterpriseRunCommand$$logSimulationConfiguration(simulationStartResult.simulation.id, simulationStartResult.simulation.className);
            }
            String reportsUrl = new StringBuilder(0).append($this.config.url().toExternalForm()).append(simulationStartResult.runSummary.reportsPath).toString();
            this.logger().info(new StringBuilder(76).append("Simulation successfully started; once running, reports will be available at ").append(reportsUrl).toString());
        }).recoverWith((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ EnterpriseRunCommand $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof UnsupportedJavaVersionException) {
                    UnsupportedJavaVersionException unsupportedJavaVersionException = (UnsupportedJavaVersionException)A1;
                    return (B1)new Failure((Throwable)new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(319).append(unsupportedJavaVersionException.getMessage()).append("\n                                                  |In order to target the supported Java bytecode version, please use Java JDK ").append(unsupportedJavaVersionException.supportedVersion).append(".\n                                                  |Or, reported class may come from your project dependencies, published targeting Java ").append(unsupportedJavaVersionException.version).append(".\n                                                  |").toString()))));
                }
                if (A1 instanceof SeveralTeamsFoundException) {
                    SeveralTeamsFoundException severalTeamsFoundException = (SeveralTeamsFoundException)A1;
                    Buffer teams = CollectionConverters$.MODULE$.ListHasAsScala(severalTeamsFoundException.getAvailableTeams()).asScala();
                    return (B1)new Failure((Throwable)new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(321).append("More than 1 team were found while creating a simulation.\n                                                  |Available teams:\n                                                  |").append(((IterableOnceOps)teams.map((Function1 & Serializable)team -> new StringBuilder(5).append("- ").append(team.id).append(" (").append(team.name).append(")").toString())).mkString(System.lineSeparator())).append("\n                                                  |Specify the team you want to use with --").append(CommandLineConstants$.MODULE$.TeamId().full()).append(" ").append(((Team)teams.head()).id).append("\n                                                  |").toString()))));
                }
                if (A1 instanceof SeveralSimulationClassNamesFoundException) {
                    SeveralSimulationClassNamesFoundException severalSimulationClassNamesFoundException = (SeveralSimulationClassNamesFoundException)A1;
                    Buffer simulationClasses = CollectionConverters$.MODULE$.ListHasAsScala(severalSimulationClassNamesFoundException.getAvailableSimulationClassNames()).asScala();
                    return (B1)new Failure((Throwable)new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(234).append("Several simulation classes were found\n                                                  |").append(((IterableOnceOps)simulationClasses.map((Function1 & Serializable)x$1 -> new StringBuilder(2).append("- ").append((String)x$1).toString())).mkString("\n")).append("\n                                                  |Specify the team you want to use with --").append(io.gatling.app.cli.CommandLineConstants$.MODULE$.Simulation().full()).append(" ").append(simulationClasses.head()).append("\n                                                  |").toString()))));
                }
                if (A1 instanceof SimulationStartException) {
                    SimulationStartException simulationStartException = (SimulationStartException)A1;
                    if (simulationStartException.isCreated()) {
                        this.$outer.io$gatling$bundle$commands$EnterpriseRunCommand$$logCreatedSimulation(simulationStartException.getSimulation());
                    }
                    this.$outer.io$gatling$bundle$commands$EnterpriseRunCommand$$logSimulationConfiguration(simulationStartException.getSimulation().id, simulationStartException.getSimulation().className);
                    return (B1)new Failure(simulationStartException.getCause());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof UnsupportedJavaVersionException) {
                    return true;
                }
                if (throwable instanceof SeveralTeamsFoundException) {
                    return true;
                }
                if (throwable instanceof SeveralSimulationClassNamesFoundException) {
                    return true;
                }
                return throwable instanceof SimulationStartException;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(io.gatling.plugin.model.Team ), $anonfun$applyOrElse$2(java.lang.String )}, serializedLambda);
            }
        }).fold((Function1 & Serializable)x$2 -> {
            throw x$2;
        }, (Function1 & Serializable)x$3 -> {
            EnterpriseRunCommand.$anonfun$run$4(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void io$gatling$bundle$commands$EnterpriseRunCommand$$logCreatedSimulation(Simulation simulation) {
        this.logger().info(new StringBuilder(36).append("Created simulation named ").append(simulation.name).append(" with ID '").append(simulation.id).append("'").toString());
    }

    public void io$gatling$bundle$commands$EnterpriseRunCommand$$logSimulationConfiguration(UUID simulationId, String classname) {
        this.logger().info(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(328).append("\n                   |Specify --").append(CommandLineConstants$.MODULE$.SimulationId().full()).append(" ").append(simulationId).append(" if you want to start a simulation on Gatling Enterprise,\n                   |or --").append(io.gatling.app.cli.CommandLineConstants$.MODULE$.Simulation().full()).append(" ").append(classname).append(" if you want to create a new simulation on Gatling Enterprise.\n                   |See https://gatling.io/docs/gatling/reference/current/core/configuration/#cli-options/ for more information.\n                   |").toString())));
    }

    public static final /* synthetic */ void $anonfun$run$4(BoxedUnit x$3) {
    }

    public EnterpriseRunCommand(CommandArguments config, List<String> args) {
        this.config = config;
        this.args = args;
        this.logger = BundleIO$.MODULE$.getLogger();
    }
}

