/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.bundle.commands;

import io.gatling.bundle.CommandArguments;
import io.gatling.bundle.commands.CommandHelper$;
import io.gatling.bundle.commands.Compiler$;
import io.gatling.bundle.commands.PackageCommand$;
import io.gatling.commons.util.Io;
import io.gatling.commons.util.Io$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005ErA\u0002\t\u0012\u0011\u0003\u0019\u0012D\u0002\u0004\u001c#!\u00051\u0003\b\u0005\u0006G\u0005!\t!J\u0003\u0005M\u0005!qEB\u0003\u001c#\t\u0019R\t\u0003\u0005G\t\t\u0005\t\u0015!\u0003H\u0011!YEA!A!\u0002\u0013a\u0005\u0002C+\u0005\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011e#!\u0011!Q\u0001\niCQa\t\u0003\u0005\u0002uCaa\u0019\u0003\u0005\u0002M!\u0007\"\u00026\u0005\t\u0013Y\u0007\"B7\u0005\t\u0013q\u0007\"B>\u0005\t\u0013a\bbBA\t\t\u0011%\u00111\u0003\u0005\b\u00033!A\u0011BA\u000e\u00039\u0001\u0016mY6bO\u0016\u001cu.\\7b]\u0012T!AE\n\u0002\u0011\r|W.\\1oINT!\u0001F\u000b\u0002\r\t,h\u000e\u001a7f\u0015\t1r#A\u0004hCRd\u0017N\\4\u000b\u0003a\t!![8\u0011\u0005i\tQ\"A\t\u0003\u001dA\u000b7m[1hK\u000e{W.\\1oIN\u0011\u0011!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\u0007\u0002\u000b/JLG/Z#oiJL\b#\u0002\u0010)UU\u0012\u0015BA\u0015 \u0005%1UO\\2uS>t'\u0007\u0005\u0002,e9\u0011A\u0006\r\t\u0003[}i\u0011A\f\u0006\u0003_\u0011\na\u0001\u0010:p_Rt\u0014BA\u0019 \u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ez\u0002\u0003\u0002\u00107q\tK!aN\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u001dA\u001b\u0005Q$BA\u001e=\u0003\rQ\u0017M\u001d\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!;\u0005=Q\u0015M](viB,Ho\u0015;sK\u0006l\u0007C\u0001\u0010D\u0013\t!uD\u0001\u0003V]&$8C\u0001\u0003\u001e\u0003\u0019\u0019wN\u001c4jOB\u0011\u0001*S\u0007\u0002'%\u0011!j\u0005\u0002\u0011\u0007>lW.\u00198e\u0003J<W/\\3oiN\fA!\u0019:hgB\u0019QJ\u0015\u0016\u000f\u00059\u0003fBA\u0017P\u0013\u0005\u0001\u0013BA) \u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0015+\u0003\t1K7\u000f\u001e\u0006\u0003#~\ta\"\\1y\u0015\u00064\u0018MV3sg&|g\u000e\u0005\u0002\u001f/&\u0011\u0001l\b\u0002\u0004\u0013:$\u0018!C2mK\u0006tg)\u001b7f!\tq2,\u0003\u0002]?\t9!i\\8mK\u0006tG#\u00020`A\u0006\u0014\u0007C\u0001\u000e\u0005\u0011\u00151\u0015\u00021\u0001H\u0011\u0015Y\u0015\u00021\u0001M\u0011\u0015)\u0016\u00021\u0001W\u0011\u0015I\u0016\u00021\u0001[\u0003\r\u0011XO\u001c\u000b\u0002KB\u0011a\r[\u0007\u0002O*\u0011\u0001DP\u0005\u0003S\u001e\u0014AAR5mK\u0006I1M]3bi\u0016T\u0015M\u001d\u000b\u0003K2DQ!W\u0006A\u0002i\u000b1\"\u00193e\u001b\u0006t\u0017NZ3tiR\u0011!i\u001c\u0005\u0006a2\u0001\r!]\u0001\u000boJLG/Z#oiJL\bC\u0001:\u0004\u001d\t\u0019\bA\u0004\u0002uu:\u0011Q/\u001f\b\u0003mbt!!L<\n\u0003aI!AF\f\n\u0005Q)\u0012B\u0001\n\u0014\u0003=\tG\r\u001a&beN\u001cuN\u001c;f]R\u001cH\u0003\u0002\"~\u0003\u001fAQA`\u0007A\u0002}\f\u0001B]8piB\u000bG\u000f\u001b\t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u00111\u0017\u000e\\3\u000b\u0007\u0005%a(A\u0002oS>LA!!\u0004\u0002\u0004\t!\u0001+\u0019;i\u0011\u0015\u0001X\u00021\u0001r\u00035\tG\r\u001a&be\u0016sGO]5fgR)!)!\u0006\u0002\u0018!)aP\u0004a\u0001\u007f\")\u0001O\u0004a\u0001c\u0006\u00192m\u001c9z\rJ|W.\u00138qkR\u001cFO]3b[R)!)!\b\u0002.!A\u0011qD\b\u0005\u0002\u0004\t\t#A\u0006j]B,Ho\u0015;sK\u0006l\u0007#\u0002\u0010\u0002$\u0005\u001d\u0012bAA\u0013?\tAAHY=oC6,g\bE\u0002g\u0003SI1!a\u000bh\u0005-Ie\u000e];u'R\u0014X-Y7\t\r\u0005=r\u00021\u00019\u0003\rQwn\u001d")
public final class PackageCommand {
    private final CommandArguments config;
    private final List<String> args;
    private final int maxJavaVersion;
    private final boolean cleanFile;

    public File run() {
        Compiler$.MODULE$.compile(this.config, this.args, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.maxJavaVersion)));
        Predef$.MODULE$.println((Object)"Creating the package");
        return this.createJar(this.cleanFile);
    }

    private File createJar(boolean cleanFile) {
        File file;
        if (cleanFile) {
            File tempFile = File.createTempFile("package", ".jar");
            tempFile.deleteOnExit();
            file = tempFile;
        } else {
            File packageFile = new File(CommandHelper$.MODULE$.TargetDirectory().toFile(), "package.jar");
            packageFile.delete();
            packageFile.createNewFile();
            file = packageFile;
        }
        File file2 = file;
        return (File)Using$.MODULE$.apply((Function0 & Serializable)() -> new JarOutputStream(new FileOutputStream(file2)), (Function1 & Serializable)jos -> {
            block0: {
                jos.setLevel(0);
                HashSet entriesCache = HashSet$.MODULE$.empty();
                Function2 & Serializable writeEntry = (Function2 & Serializable)(entryName, writeContent) -> {
                    PackageCommand.$anonfun$createJar$3(entriesCache, jos, entryName, writeContent);
                    return BoxedUnit.UNIT;
                };
                this.addManifest((Function2<String, Function1<JarOutputStream, BoxedUnit>, BoxedUnit>)writeEntry);
                this.addJarEntries($this.config.binariesDirectory(), (Function2<String, Function1<JarOutputStream, BoxedUnit>, BoxedUnit>)writeEntry);
                this.addJarEntries($this.config.resourcesDirectory(), (Function2<String, Function1<JarOutputStream, BoxedUnit>, BoxedUnit>)writeEntry);
                this.addJarsContents(CommandHelper$.MODULE$.UserLibDirectory(), (Function2<String, Function1<JarOutputStream, BoxedUnit>, BoxedUnit>)writeEntry);
                Predef$.MODULE$.println((Object)"Package created");
                if (cleanFile) break block0;
                Predef$.MODULE$.println((Object)new StringBuilder(27).append("Package can be found here: ").append(file2.getAbsolutePath()).toString());
            }
            return file2;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).fold((Function1 & Serializable)x$1 -> {
            throw x$1;
        }, (Function1 & Serializable)x -> (File)Predef$.MODULE$.identity(x));
    }

    private void addManifest(Function2<String, Function1<JarOutputStream, BoxedUnit>, BoxedUnit> writeEntry) {
        writeEntry.apply((Object)"META-INF/", (Function1 & Serializable)x$2 -> {
            PackageCommand.$anonfun$addManifest$1(x$2);
            return BoxedUnit.UNIT;
        });
        writeEntry.apply((Object)"META-INF/MANIFEST.MF", (Function1 & Serializable)jos -> {
            PackageCommand.$anonfun$addManifest$2(jos);
            return BoxedUnit.UNIT;
        });
    }

    private void addJarsContents(Path rootPath, Function2<String, Function1<JarOutputStream, BoxedUnit>, BoxedUnit> writeEntry) {
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, writeEntry, rootPath){
            private final /* synthetic */ PackageCommand $outer;
            private final Function2 writeEntry$1;
            private final Path rootPath$1;

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                Object object = Files.isRegularFile(path, new LinkOption[0]) && ((Object)path.getFileName()).toString().toLowerCase(Locale.ENGLISH).endsWith(".jar") ? Using$.MODULE$.apply((Function0 & Serializable)() -> new ZipFile(path.toFile()), (Function1 & Serializable)zip -> {
                    $anon$1.$anonfun$visitFile$2(this, zip);
                    return BoxedUnit.UNIT;
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).fold((Function1 & Serializable)x$3 -> {
                    throw x$3;
                }, (Function1 & Serializable)x$4 -> {
                    $anon$1.$anonfun$visitFile$8(x$4);
                    return BoxedUnit.UNIT;
                }) : BoxedUnit.UNIT;
                return super.visitFile(this.rootPath$1, attrs);
            }

            public static final /* synthetic */ boolean $anonfun$visitFile$3($anon$1 $this, ZipEntry entry) {
                return !PackageCommand.io$gatling$bundle$commands$PackageCommand$$isExcluded$1(entry.getName());
            }

            public static final /* synthetic */ void $anonfun$visitFile$5($anon$1 $this, ZipEntry entry$1, ZipFile zip$1, JarOutputStream jos) {
                if (!entry$1.isDirectory()) {
                    $this.$outer.io$gatling$bundle$commands$PackageCommand$$copyFromInputStream((Function0<InputStream>)(Function0 & Serializable)() -> zip$1.getInputStream(entry$1), jos);
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$visitFile$4($anon$1 $this, ZipFile zip$1, ZipEntry entry) {
                $this.writeEntry$1.apply((Object)entry.getName(), (Function1 & Serializable)jos -> {
                    $anon$1.$anonfun$visitFile$5($this, entry, zip$1, jos);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$visitFile$2($anon$1 $this, ZipFile zip) {
                CollectionConverters$.MODULE$.EnumerationHasAsScala(zip.entries()).asScala().filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$visitFile$3($this, entry))).foreach((Function1 & Serializable)entry -> {
                    $anon$1.$anonfun$visitFile$4($this, zip, entry);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$visitFile$8(BoxedUnit x$4) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.writeEntry$1 = writeEntry$1;
                this.rootPath$1 = rootPath$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visitFile$1(java.nio.file.Path ), $anonfun$visitFile$2$adapted(io.gatling.bundle.commands.PackageCommand$$anon$1 java.util.zip.ZipFile ), $anonfun$visitFile$3$adapted(io.gatling.bundle.commands.PackageCommand$$anon$1 java.util.zip.ZipEntry ), $anonfun$visitFile$4$adapted(io.gatling.bundle.commands.PackageCommand$$anon$1 java.util.zip.ZipFile java.util.zip.ZipEntry ), $anonfun$visitFile$5$adapted(io.gatling.bundle.commands.PackageCommand$$anon$1 java.util.zip.ZipEntry java.util.zip.ZipFile java.util.jar.JarOutputStream ), $anonfun$visitFile$6(java.util.zip.ZipFile java.util.zip.ZipEntry ), $anonfun$visitFile$7(java.lang.Throwable ), $anonfun$visitFile$8$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
    }

    private void addJarEntries(Path rootPath, Function2<String, Function1<JarOutputStream, BoxedUnit>, BoxedUnit> writeEntry) {
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, writeEntry, rootPath){
            private final /* synthetic */ PackageCommand $outer;
            private final Function2 writeEntry$2;
            private final Path rootPath$2;

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                this.writeEntry$2.apply((Object)((Object)this.rootPath$2.relativize(path)).toString(), (Function1 & Serializable)jos -> {
                    $anon$2.$anonfun$visitFile$9(this, path, jos);
                    return BoxedUnit.UNIT;
                });
                return super.visitFile(this.rootPath$2, attrs);
            }

            public static final /* synthetic */ void $anonfun$visitFile$9($anon$2 $this, Path path$2, JarOutputStream jos) {
                if (Files.isRegularFile(path$2, new LinkOption[0])) {
                    $this.$outer.io$gatling$bundle$commands$PackageCommand$$copyFromInputStream((Function0<InputStream>)(Function0 & Serializable)() -> Files.newInputStream(path$2, new OpenOption[0]), jos);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.writeEntry$2 = writeEntry$2;
                this.rootPath$2 = rootPath$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visitFile$10(java.nio.file.Path ), $anonfun$visitFile$9$adapted(io.gatling.bundle.commands.PackageCommand$$anon$2 java.nio.file.Path java.util.jar.JarOutputStream )}, serializedLambda);
            }
        });
    }

    public void io$gatling$bundle$commands$PackageCommand$$copyFromInputStream(Function0<InputStream> inputStream, JarOutputStream jos) {
        Using$.MODULE$.resource(inputStream.apply(), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)PackageCommand.$anonfun$copyFromInputStream$1(jos, x$5)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        jos.flush();
    }

    public static final /* synthetic */ void $anonfun$createJar$3(HashSet entriesCache$1, JarOutputStream jos$1, String entryName, Function1 writeContent) {
        String fixedEntryName = entryName.replace('\\', '/');
        JarEntry entry = new JarEntry(fixedEntryName);
        if (entriesCache$1.add((Object)fixedEntryName)) {
            jos$1.putNextEntry(entry);
            writeContent.apply((Object)jos$1);
            jos$1.closeEntry();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$addManifest$1(JarOutputStream x$2) {
    }

    public static final /* synthetic */ void $anonfun$addManifest$2(JarOutputStream jos) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        manifest.getMainAttributes().putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "GatlingCorp");
        manifest.getMainAttributes().putValue("Gatling-Packager", "bundle");
        manifest.getMainAttributes().putValue("Gatling-Version", CommandHelper$.MODULE$.GatlingVersion());
        manifest.write(jos);
    }

    public static final boolean io$gatling$bundle$commands$PackageCommand$$isExcluded$1(String name) {
        return name.equalsIgnoreCase("META-INF/LICENSE") || name.equalsIgnoreCase("META-INF/MANIFEST.MF") || name.startsWith("META-INF/versions/") || name.startsWith("META-INF/maven/") || name.endsWith(".SF") || name.endsWith(".DSA") || name.endsWith(".RSA");
    }

    public static final /* synthetic */ int $anonfun$copyFromInputStream$1(JarOutputStream jos$2, InputStream x$5) {
        InputStream qual$1 = Io$.MODULE$.RichInputStream(x$5);
        JarOutputStream x$1 = jos$2;
        int x$2 = Io.RichInputStream$.MODULE$.copyTo$default$2$extension(qual$1);
        return Io.RichInputStream$.MODULE$.copyTo$extension(qual$1, (OutputStream)x$1, x$2);
    }

    public PackageCommand(CommandArguments config, List<String> args, int maxJavaVersion, boolean cleanFile) {
        this.config = config;
        this.args = args;
        this.maxJavaVersion = maxJavaVersion;
        this.cleanFile = cleanFile;
    }
}

