/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.bundle.commands;

import io.gatling.bundle.BundleIO$;
import io.gatling.bundle.CommandArguments;
import io.gatling.bundle.CommandArguments$RunEnterprise$;
import io.gatling.bundle.CommandArguments$RunLocal$;
import io.gatling.bundle.CommandArguments$RunPackage$;
import io.gatling.bundle.CommandLineConstants$;
import io.gatling.bundle.EnterpriseBundlePlugin$;
import io.gatling.bundle.commands.EnterpriseRunCommand;
import io.gatling.bundle.commands.OpenSourceRunCommand;
import io.gatling.bundle.commands.PackageCommand;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.io.PluginIO;
import io.gatling.plugin.io.input.InputChoice;
import io.gatling.plugin.model.ServerInformation;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r3Qa\u0002\u0005\u0003\u0015AA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\t;\u0001\u0011\t\u0011)A\u0005=!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u0003:\u0001\u0011\u0005!\b\u0003\u0004A\u0001\u0011\u0005!\"\u0011\u0005\u0006\u0005\u0002!I!\u0011\u0002\u000b%Vt7i\\7nC:$'BA\u0005\u000b\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0006\r\u0003\u0019\u0011WO\u001c3mK*\u0011QBD\u0001\bO\u0006$H.\u001b8h\u0015\u0005y\u0011AA5p'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VMZ\u0001\u0007G>tg-[4\u0004\u0001A\u0011!dG\u0007\u0002\u0015%\u0011AD\u0003\u0002\u0011\u0007>lW.\u00198e\u0003J<W/\\3oiN\fA!\u0019:hgB\u0019qd\n\u0016\u000f\u0005\u0001*cBA\u0011%\u001b\u0005\u0011#BA\u0012\u0019\u0003\u0019a$o\\8u}%\tA#\u0003\u0002''\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0015*\u0005\u0011a\u0015n\u001d;\u000b\u0005\u0019\u001a\u0002CA\u00160\u001d\taS\u0006\u0005\u0002\"'%\u0011afE\u0001\u0007!J,G-\u001a4\n\u0005A\n$AB*ue&twM\u0003\u0002/'\u0005YA-[:qY\u0006L\b*\u001a7q!\r\u0011BGN\u0005\u0003kM\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005I9\u0014B\u0001\u001d\u0014\u0005\u0011)f.\u001b;\u0002\rqJg.\u001b;?)\u0011YTHP \u0011\u0005q\u0002Q\"\u0001\u0005\t\u000b]!\u0001\u0019A\r\t\u000bu!\u0001\u0019\u0001\u0010\t\u000bI\"\u0001\u0019A\u001a\u0002\u0007I,h\u000eF\u00017\u0003E\u0011XO\u001c)bG.\fw-Z\"p[6\fg\u000e\u001a")
public final class RunCommand {
    private final CommandArguments config;
    private final List<String> args;
    private final Function0<BoxedUnit> displayHelp;

    public void run() {
        String choice;
        Option<CommandArguments.RunMode> option = this.config.runMode();
        if (option instanceof Some) {
            Some some = (Some)option;
            CommandArguments.RunMode runMode = (CommandArguments.RunMode)some.value();
            CommandArguments.RunMode runMode2 = runMode;
            if (CommandArguments$RunLocal$.MODULE$.equals(runMode2)) {
                new OpenSourceRunCommand(this.config, this.args).run();
            } else if (CommandArguments$RunEnterprise$.MODULE$.equals(runMode2)) {
                new EnterpriseRunCommand(this.config, this.args).run();
            } else if (CommandArguments$RunPackage$.MODULE$.equals(runMode2)) {
                this.runPackageCommand();
            } else {
                throw new MatchError((Object)runMode2);
            }
            return;
        }
        if (this.config.simulationId().nonEmpty()) {
            Predef$.MODULE$.println((Object)"Running the Simulation on Gatling Enterprise");
            new EnterpriseRunCommand(this.config, this.args).run();
            return;
        }
        if (this.config.reportsOnly().nonEmpty()) {
            Predef$.MODULE$.println((Object)"Generating Gatling reports locally");
            new OpenSourceRunCommand(this.config, this.args).run();
            return;
        }
        if (this.config.batchMode()) {
            throw new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(370).append("\n               |If you're running Gatling in batch mode, you need to set the runMode option:\n               |- '--").append(CommandLineConstants$.MODULE$.RunMode().full()).append(" ").append(CommandArguments$RunLocal$.MODULE$.value()).append("' if you want to start the Simulation locally\n               |- '--").append(CommandLineConstants$.MODULE$.RunMode().full()).append(" ").append(CommandArguments$RunEnterprise$.MODULE$.value()).append("' if you want to upload the Simulation to Gatling Enterprise Cloud, and run it there\n               |- '--").append(CommandLineConstants$.MODULE$.RunMode().full()).append(" ").append(CommandArguments$RunPackage$.MODULE$.value()).append("' if you want to package the Simulation for Gatling Enterprise\n               |").toString())));
        }
        Predef$.MODULE$.println((Object)"Do you want to run the simulation locally, on Gatling Enterprise, or just package it?");
        InputChoice inputChoice = new InputChoice((PluginIO)BundleIO$.MODULE$);
        String RunGatlingOpenSource = "Run the Simulation locally";
        String RunGatlingEnterprise = "Package and upload the Simulation to Gatling Enterprise Cloud, and run it there";
        String RunPackage = "Package the Simulation for Gatling Enterprise";
        String RunHelp = "Show help and exit";
        String string = choice = inputChoice.inputFromStringList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)RunGatlingOpenSource, (List)new .colon.colon((Object)RunGatlingEnterprise, (List)new .colon.colon((Object)RunPackage, (List)new .colon.colon((Object)RunHelp, (List)Nil$.MODULE$))))).asJava(), false);
        String string2 = RunGatlingOpenSource;
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            new OpenSourceRunCommand(this.config, this.args).run();
        } else {
            String string4 = RunPackage;
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.runPackageCommand();
            } else {
                String string6 = RunGatlingEnterprise;
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    new EnterpriseRunCommand(this.config, this.args).run();
                } else {
                    String string8 = RunHelp;
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        this.displayHelp.apply$mcV$sp();
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(37).append("Couldn't recognize the chosen option ").append(choice).toString());
                    }
                }
            }
        }
    }

    private void runPackageCommand() {
        int maxJavaVersion = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            EnterpriseClient enterpriseClient = EnterpriseBundlePlugin$.MODULE$.getClient($this.config);
            ServerInformation serverInformation = enterpriseClient.getServerInformation();
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(serverInformation.versions.java.max));
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 17));
        new PackageCommand(this.config, this.args, maxJavaVersion, false).run();
    }

    public RunCommand(CommandArguments config, List<String> args, Function0<BoxedUnit> displayHelp) {
        this.config = config;
        this.args = args;
        this.displayHelp = displayHelp;
    }
}

