/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.Redirect;
import io.gatling.http.engine.response.RedirectProcessor$;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.nio.charset.Charset;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class ResponseProcessor$
implements StrictLogging {
    public static final ResponseProcessor$ MODULE$ = new ResponseProcessor$();
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public ProcessorResult processResponse(HttpTx tx, SessionProcessor sessionProcessor, Charset defaultCharset, Response response) {
        ProcessorResult processorResult;
        block12: {
            try {
                if (HttpHelper$.MODULE$.isRedirect(response.status()) && tx.request().requestConfig().followRedirect()) {
                    if (tx.redirectCount() >= tx.request().requestConfig().httpProtocol().responsePart().maxRedirects()) {
                        processorResult = new Crash(new StringBuilder(27).append("Too many redirects, max is ").append(tx.request().requestConfig().httpProtocol().responsePart().maxRedirects()).toString());
                    } else {
                        String location = response.headers().get((CharSequence)HttpHeaderNames.LOCATION);
                        if (location == null) {
                            processorResult = new Crash("Redirect status, yet no Location header");
                        } else {
                            Uri redirectUri = HttpHelper$.MODULE$.resolveFromUri(tx.request().clientRequest().getUri(), location);
                            Session newSession = sessionProcessor.updatedRedirectSession(tx.currentSession(), response, redirectUri);
                            Request redirectRequest = RedirectProcessor$.MODULE$.redirectRequest(tx.request().clientRequest(), newSession, response.status(), tx.request().requestConfig().httpProtocol(), redirectUri, defaultCharset);
                            Session x$4 = newSession;
                            Request x$1 = redirectRequest;
                            String x$2 = tx.request().copy$default$1();
                            HttpRequestConfig x$3 = tx.request().copy$default$3();
                            HttpRequest x$5 = tx.request().copy(x$2, x$1, x$3);
                            int x$6 = tx.redirectCount() + 1;
                            Action x$7 = tx.copy$default$3();
                            Option<ResourceTx> x$8 = tx.copy$default$4();
                            Redirect redirect = new Redirect(tx.copy(x$4, x$5, x$7, x$8, x$6));
                            processorResult = redirect;
                        }
                    }
                    break block12;
                }
                Tuple2<Session, Option<String>> tuple2 = sessionProcessor.updatedSession(tx.currentSession(), response);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Session newSession = (Session)tuple2._1();
                Option errorMessage = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)newSession, (Object)errorMessage);
                Tuple2 tuple23 = tuple22;
                Session newSession2 = (Session)tuple23._1();
                Option errorMessage2 = (Option)tuple23._2();
                processorResult = new Proceed(newSession2, (Option<String>)errorMessage2);
            }
            catch (Throwable throwable) {
                Throwable t;
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    t = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(85).append("ResponseProcessor crashed while handling response ").append(response.status()).append(" on session=").append(tx.currentSession()).append(" request=").append(tx.request().requestName()).append(": ").append(tx.request().clientRequest()).append(", forwarding").toString(), t);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                Crash crash = new Crash(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
                processorResult = crash;
            }
        }
        return processorResult;
    }

    public Session processFailure(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, HttpFailure failure) {
        Session sessionWithUpdatedStats = sessionProcessor.updateSessionCrashed(tx.session(), failure.startTimestamp(), failure.endTimestamp());
        try {
            statsProcessor.reportStats(tx.fullRequestName(), sessionWithUpdatedStats, (Status)KO$.MODULE$, failure, (Option<String>)new Some((Object)failure.errorMessage()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable t = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(84).append("ResponseProcessor crashed while handling failure ").append(failure).append(" on session=").append(tx.session()).append(" request=").append(tx.request().requestName()).append(": ").append(tx.request().clientRequest()).append(", forwarding").toString(), t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
        return sessionWithUpdatedStats;
    }

    private ResponseProcessor$() {
    }
}

