/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.ssl;

import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.http.ssl.HttpsMode;
import io.gatling.recorder.http.ssl.HttpsMode$CertificateAuthority$;
import io.gatling.recorder.http.ssl.HttpsMode$ProvidedKeyStore$;
import io.gatling.recorder.http.ssl.HttpsMode$SelfSignedCertificate$;
import io.gatling.recorder.http.ssl.KeyStoreType;
import io.gatling.recorder.http.ssl.SslServerContext;
import io.gatling.recorder.http.ssl.SslServerContext$SelfSignedCertificate$;
import java.io.File;
import java.io.Serializable;
import java.security.Security;
import scala.Function0;
import scala.MatchError;
import scala.Option$;

public final class SslServerContext$ {
    public static final SslServerContext$ MODULE$ = new SslServerContext$();
    private static final String io$gatling$recorder$http$ssl$SslServerContext$$Algorithm = (String)Option$.MODULE$.apply((Object)Security.getProperty("ssl.KeyManagerFactory.algorithm")).getOrElse((Function0 & Serializable)() -> "SunX509");

    public String io$gatling$recorder$http$ssl$SslServerContext$$Algorithm() {
        return io$gatling$recorder$http$ssl$SslServerContext$$Algorithm;
    }

    public SslServerContext apply(RecorderConfiguration config) {
        SslServerContext sslServerContext;
        HttpsMode httpsMode = config.proxy().https().mode();
        if (HttpsMode$SelfSignedCertificate$.MODULE$.equals(httpsMode)) {
            sslServerContext = SslServerContext$SelfSignedCertificate$.MODULE$;
        } else if (HttpsMode$ProvidedKeyStore$.MODULE$.equals(httpsMode)) {
            File ksFile = new File(config.proxy().https().keyStore().path());
            KeyStoreType keyStoreType = config.proxy().https().keyStore().keyStoreType();
            char[] password = config.proxy().https().keyStore().password().toCharArray();
            sslServerContext = new SslServerContext.ProvidedKeystore(ksFile, keyStoreType, password);
        } else if (HttpsMode$CertificateAuthority$.MODULE$.equals(httpsMode)) {
            sslServerContext = new SslServerContext.OnTheFly(config.proxy().https().certificateAuthority().certificatePath(), config.proxy().https().certificateAuthority().privateKeyPath());
        } else {
            throw new MatchError((Object)httpsMode);
        }
        return sslServerContext;
    }

    private SslServerContext$() {
    }
}

