/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.baggage;

import io.grpc.Context;
import io.opentelemetry.baggage.Baggage;
import io.opentelemetry.baggage.EmptyBaggage;
import io.opentelemetry.context.ContextUtils;
import io.opentelemetry.context.Scope;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BaggageUtils {
    private static final Context.Key<Baggage> CORR_CONTEXT_KEY = Context.key((String)"opentelemetry-corr-context-key");

    public static Context withBaggage(Baggage baggage, Context context) {
        return context.withValue(CORR_CONTEXT_KEY, (Object)baggage);
    }

    public static Baggage getCurrentBaggage() {
        return BaggageUtils.getBaggage(Context.current());
    }

    public static Baggage getBaggage(Context context) {
        Baggage baggage = (Baggage)CORR_CONTEXT_KEY.get(context);
        return baggage == null ? EmptyBaggage.getInstance() : baggage;
    }

    @Nullable
    public static Baggage getBaggageWithoutDefault(Context context) {
        return (Baggage)CORR_CONTEXT_KEY.get(context);
    }

    public static Scope currentContextWith(Baggage baggage) {
        Context context = BaggageUtils.withBaggage(baggage, Context.current());
        return ContextUtils.withScopedContext((Context)context);
    }

    private BaggageUtils() {
    }
}

