/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.DotNames;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

final class AssignabilityCheck {
    private final ConcurrentMap<DotName, Set<DotName>> cache = new ConcurrentHashMap<DotName, Set<DotName>>();
    private final IndexView index;

    public AssignabilityCheck(IndexView beanArchiveIndex, IndexView applicationIndex) {
        this.index = applicationIndex != null ? CompositeIndex.create((IndexView[])new IndexView[]{beanArchiveIndex, applicationIndex}) : beanArchiveIndex;
    }

    boolean isAssignableFrom(Type type1, Type type2) {
        if (type1.name().equals((Object)DotNames.OBJECT)) {
            return true;
        }
        if (type1.name().equals((Object)type2.name())) {
            return true;
        }
        return this.getAssignables(type1.name()).contains(type2.name());
    }

    Set<DotName> getAssignables(DotName name) {
        return this.cache.computeIfAbsent(name, this::findAssignables);
    }

    private Set<DotName> findAssignables(DotName name) {
        HashSet<DotName> assignables = new HashSet<DotName>();
        for (ClassInfo subclass : this.index.getAllKnownSubclasses(name)) {
            assignables.add(subclass.name());
        }
        for (ClassInfo implementor : this.index.getAllKnownImplementors(name)) {
            assignables.add(implementor.name());
        }
        return assignables;
    }
}

