/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.vertx;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.undertow.websockets.ConfiguredServerEndpoint;
import io.undertow.websockets.DefaultContainerConfigurator;
import io.undertow.websockets.EncodingFactory;
import io.undertow.websockets.EndpointSessionHandler;
import io.undertow.websockets.JsrWebSocketMessages;
import io.undertow.websockets.ServerWebSocketContainer;
import io.undertow.websockets.WebSocketReconnectHandler;
import io.undertow.websockets.annotated.AnnotatedEndpointFactory;
import io.undertow.websockets.handshake.Handshake;
import io.undertow.websockets.handshake.HandshakeUtil;
import io.undertow.websockets.handshake.WebSocketHttpExchange;
import io.undertow.websockets.util.ContextSetupHandler;
import io.undertow.websockets.util.ObjectFactory;
import io.undertow.websockets.util.ObjectHandle;
import io.undertow.websockets.util.ObjectIntrospecter;
import io.undertow.websockets.util.PathTemplate;
import io.undertow.websockets.vertx.VertxWebSocketHttpExchange;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;

public class VertxServerWebSocketContainer
extends ServerWebSocketContainer {
    public VertxServerWebSocketContainer(ObjectIntrospecter objectIntrospecter, ClassLoader classLoader, Supplier<EventLoopGroup> eventLoopSupplier, List<ContextSetupHandler> contextSetupHandlers, boolean dispatchToWorker, InetSocketAddress clientBindAddress, WebSocketReconnectHandler reconnectHandler, Supplier<Executor> executorSupplier, List<Extension> installedExtensions, int maxFrameSize, Supplier<Principal> currentUserSupplier) {
        super(objectIntrospecter, classLoader, eventLoopSupplier, contextSetupHandlers, dispatchToWorker, clientBindAddress, reconnectHandler, executorSupplier, installedExtensions, maxFrameSize, currentUserSupplier);
    }

    public void doUpgrade(RoutingContext routingContext, final ServerEndpointConfig sec, Map<String, String> pathParams) {
        ServerEndpointConfig.Configurator configurator = sec.getConfigurator();
        try {
            EncodingFactory encodingFactory = EncodingFactory.createFactory((ObjectIntrospecter)this.objectIntrospecter, (List)sec.getDecoders(), (List)sec.getEncoders());
            PathTemplate pt = PathTemplate.create((String)sec.getPath());
            ObjectFactory ObjectFactory2 = null;
            try {
                ObjectFactory2 = this.objectIntrospecter.createInstanceFactory(sec.getEndpointClass());
            }
            catch (Exception e) {
                if (configurator == null || configurator.getClass() == ServerEndpointConfig.Configurator.class) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                }
                ObjectFactory2 = new ObjectFactory<Object>(){

                    public ObjectHandle<Object> createInstance() {
                        throw JsrWebSocketMessages.MESSAGES.endpointDoesNotHaveAppropriateConstructor(sec.getEndpointClass());
                    }
                };
            }
            if (configurator == null) {
                configurator = DefaultContainerConfigurator.INSTANCE;
            }
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create((Class)sec.getEndpointClass(), (String)sec.getPath()).decoders(sec.getDecoders()).encoders(sec.getEncoders()).subprotocols(sec.getSubprotocols()).extensions(sec.getExtensions()).configurator(configurator).build();
            AnnotatedEndpointFactory annotatedEndpointFactory = null;
            if (!Endpoint.class.isAssignableFrom(sec.getEndpointClass())) {
                annotatedEndpointFactory = AnnotatedEndpointFactory.create((Class)sec.getEndpointClass(), (EncodingFactory)encodingFactory, (Set)pt.getParameterNames());
            }
            final ConfiguredServerEndpoint confguredServerEndpoint = annotatedEndpointFactory == null ? new ConfiguredServerEndpoint(config, ObjectFactory2, null, encodingFactory) : new ConfiguredServerEndpoint(config, ObjectFactory2, null, encodingFactory, annotatedEndpointFactory, this.installedExtensions);
            ServerWebSocketContainer.WebSocketHandshakeHolder hand = this.handshakes(confguredServerEndpoint);
            ChannelPipeline pipeline = ((ConnectionBase)routingContext.request().connection()).channel().pipeline();
            ChannelHandler websocketChannelHandler = pipeline.get("webSocketExtensionHandler");
            if (websocketChannelHandler != null) {
                pipeline.remove(websocketChannelHandler);
            }
            final VertxWebSocketHttpExchange facade = this.createHttpExchange(routingContext);
            Handshake handshaker = null;
            for (Handshake method : hand.handshakes) {
                if (!method.matches((WebSocketHttpExchange)facade)) continue;
                handshaker = method;
                break;
            }
            if (handshaker != null) {
                if (this.isClosed()) {
                    routingContext.response().setStatusCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).end();
                    return;
                }
                facade.putAttachment(HandshakeUtil.PATH_PARAMS, pathParams);
                Handshake selected = handshaker;
                handshaker.handshake((WebSocketHttpExchange)facade, (Consumer)new Consumer<ChannelHandlerContext>(){

                    @Override
                    public void accept(ChannelHandlerContext context) {
                        new EndpointSessionHandler((ServerWebSocketContainer)VertxServerWebSocketContainer.this).connected(context, confguredServerEndpoint, (WebSocketHttpExchange)facade, null);
                    }
                });
            }
        }
        catch (Exception e) {
            routingContext.fail((Throwable)e);
        }
    }

    protected VertxWebSocketHttpExchange createHttpExchange(RoutingContext routingContext) {
        return new VertxWebSocketHttpExchange((Executor)this.getExecutorSupplier().get(), routingContext);
    }
}

