/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics;

import io.quarkus.analytics.AnonymousUserId;
import io.quarkus.analytics.config.FileLocations;
import io.quarkus.analytics.config.GroupIdFilter;
import io.quarkus.analytics.dto.config.AnalyticsRemoteConfig;
import io.quarkus.analytics.dto.config.LocalConfig;
import io.quarkus.analytics.dto.config.NoopRemoteConfig;
import io.quarkus.analytics.dto.config.RemoteConfig;
import io.quarkus.analytics.rest.ConfigClient;
import io.quarkus.analytics.util.FileUtils;
import io.quarkus.analytics.util.PropertyUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class ConfigService {
    public static final String QUARKUS_ANALYTICS_DISABLED_LOCAL_PROP = "quarkus.analytics.disabled";
    public static final String QUARKUS_ANALYTICS_PROMPT_TIMEOUT = "quarkus.analytics.prompt.timeout";
    private static final String NEW_LINE = System.lineSeparator();
    public static final String ACCEPTANCE_PROMPT = NEW_LINE + "----------------------------" + NEW_LINE + "--- Help improve Quarkus ---" + NEW_LINE + "----------------------------" + NEW_LINE + "* Learn more: https://quarkus.io/usage/" + NEW_LINE + "* Do you agree to contribute anonymous build time data to the Quarkus community? (y/n) " + NEW_LINE;
    private static final int DEFAULT_REFRESH_HOURS = 12;
    private AnalyticsRemoteConfig config;
    private Instant lastRefreshTime;
    private final ConfigClient client;
    private final AnonymousUserId userId;
    private final Path remoteConfigFile;
    private final Path localConfigFile;
    private final MessageWriter log;

    private static Instant initLastRefreshTime(Path configFile) {
        if (Files.exists(configFile, new LinkOption[0])) {
            try {
                return Files.getLastModifiedTime(configFile, new LinkOption[0]).toInstant();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public ConfigService(ConfigClient client, AnonymousUserId userId, FileLocations fileLocations, MessageWriter log) {
        this.client = client;
        this.userId = userId;
        this.log = log;
        this.lastRefreshTime = ConfigService.initLastRefreshTime(fileLocations.getRemoteConfigFile());
        this.remoteConfigFile = fileLocations.getRemoteConfigFile();
        this.localConfigFile = fileLocations.getLocalConfigFile();
        this.loadConfig(RemoteConfig.class, this.remoteConfigFile).ifPresentOrElse(c -> {
            this.config = c;
        }, this::loadConfigFromInternet);
    }

    public void userAcceptance(Function<String, String> analyticsEnabledSupplier) {
        int timeout = PropertyUtils.getProperty(QUARKUS_ANALYTICS_PROMPT_TIMEOUT, 10);
        if (Files.exists(this.localConfigFile, new LinkOption[0]) || PropertyUtils.getProperty(QUARKUS_ANALYTICS_DISABLED_LOCAL_PROP, false)) {
            return;
        }
        try {
            CompletableFuture<String> userInputFuture = CompletableFuture.supplyAsync(() -> (String)analyticsEnabledSupplier.apply(ACCEPTANCE_PROMPT));
            String userInput = userInputFuture.get(timeout, TimeUnit.SECONDS).toLowerCase().trim();
            if (!this.validInput(userInput)) {
                this.log.info("[Quarkus build analytics] Didn't receive a valid user's answer: `y` or `n`. The question will be asked again next time." + NEW_LINE);
                return;
            }
            boolean isActive = userInput.equals("y") || userInput.equals("yes") || userInput.startsWith("yy");
            FileUtils.createFileAndParent(this.localConfigFile);
            boolean isDisabled = !isActive;
            FileUtils.write(new LocalConfig(isDisabled), this.localConfigFile);
            this.log.info("[Quarkus build analytics] Quarkus Build Analytics " + (isActive ? "enabled" : "disabled") + " by the user." + NEW_LINE);
        }
        catch (TimeoutException e) {
            this.log.info("[Quarkus build analytics] Didn't receive the user's answer after " + timeout + " seconds. The question will be asked again next time." + NEW_LINE);
        }
        catch (Exception e) {
            this.log.info("[Quarkus build analytics] Analytics config file was not written successfully. " + e.getClass().getName() + ": " + (e.getMessage() == null ? "(no message)" : e.getMessage()));
        }
    }

    public boolean isActive() {
        if (!Files.exists(this.localConfigFile, new LinkOption[0])) {
            return false;
        }
        if (!this.loadConfig(LocalConfig.class, this.localConfigFile).map(localConfig -> !localConfig.isDisabled()).orElse(true).booleanValue()) {
            return false;
        }
        if (PropertyUtils.getProperty(QUARKUS_ANALYTICS_DISABLED_LOCAL_PROP, false)) {
            return false;
        }
        AnalyticsRemoteConfig analyticsRemoteConfig = this.getRemoteConfig();
        return analyticsRemoteConfig.isActive() && this.isUserEnabled(analyticsRemoteConfig, this.userId.getUuid());
    }

    public boolean isArtifactActive(String groupId, String quarkusVersion) {
        return GroupIdFilter.isAuthorizedGroupId(groupId, this.log) && this.getRemoteConfig().getDenyQuarkusVersions().stream().noneMatch(version -> version.equals(quarkusVersion));
    }

    boolean isUserEnabled(AnalyticsRemoteConfig analyticsRemoteConfig, String user) {
        return analyticsRemoteConfig.getDenyAnonymousIds().stream().noneMatch(uId -> uId.equals(user));
    }

    private boolean validInput(String input) {
        String[] allowedValues;
        for (String allowedValue : allowedValues = new String[]{"n", "nn", "no", "y", "yy", "yes"}) {
            if (!input.equalsIgnoreCase(allowedValue)) continue;
            return true;
        }
        return false;
    }

    private AnalyticsRemoteConfig getRemoteConfig() {
        if (this.shouldRefresh()) {
            this.loadConfigFromInternet();
        }
        return this.config;
    }

    private boolean shouldRefresh() {
        return this.lastRefreshTime == null || Duration.between(this.lastRefreshTime, Instant.now()).compareTo(this.config.getRefreshInterval()) > 0;
    }

    private <T> Optional<T> loadConfig(Class<T> clazz, Path file) {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                return FileUtils.read(clazz, file, this.log);
            }
            return Optional.empty();
        }
        catch (IOException e) {
            this.log.warn("[Quarkus build analytics] Failed to read " + file.getFileName() + ". Exception: " + e.getMessage());
            return Optional.empty();
        }
    }

    private void loadConfigFromInternet() {
        AnalyticsRemoteConfig analyticsRemoteConfig = this.client.getConfig().orElse(this.checkAgainConfig());
        this.lastRefreshTime = Instant.now();
        this.config = this.storeRemoteConfigOnDisk(analyticsRemoteConfig);
    }

    private AnalyticsRemoteConfig storeRemoteConfigOnDisk(AnalyticsRemoteConfig config) {
        try {
            if (!Files.exists(this.remoteConfigFile, new LinkOption[0])) {
                FileUtils.createFileAndParent(this.remoteConfigFile);
            }
            FileUtils.write(config, this.remoteConfigFile);
            return config;
        }
        catch (IOException e) {
            this.log.warn("[Quarkus build analytics] Failed to save remote config file. Analytics will be skipped. Exception: " + e.getMessage());
            return NoopRemoteConfig.INSTANCE;
        }
    }

    private AnalyticsRemoteConfig checkAgainConfig() {
        return RemoteConfig.builder().active(false).denyQuarkusVersions(Collections.emptyList()).denyUserIds(Collections.emptyList()).refreshInterval(Duration.ofHours(12L)).build();
    }
}

