/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics.rest;

import io.quarkus.analytics.dto.config.AnalyticsRemoteConfig;
import io.quarkus.analytics.dto.config.Identity;
import io.quarkus.analytics.dto.config.RemoteConfig;
import io.quarkus.analytics.dto.segment.Track;
import io.quarkus.analytics.rest.ConfigClient;
import io.quarkus.analytics.rest.SegmentClient;
import io.quarkus.analytics.util.PropertyUtils;
import io.quarkus.analytics.util.StringUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RestClient
implements ConfigClient,
SegmentClient {
    public static final int DEFAULT_TIMEOUT = 3000;
    static final String IDENTITY_ENDPOINT = "v1/identify";
    static final String TRACK_ENDPOINT = "v1/track";
    static final URI CONFIG_URI = RestClient.getUri("https://quarkus.io/assets/json/03656937-19FD-4C83-9066-C76631D445EA.json");
    private static final String AUTH_HEADER = RestClient.getAuthHeader("WdCBreXheGC541sGjMMvUknY8c6lLxy5");
    private static final int SEGMENT_POST_RESPONSE_CODE = 200;
    private final MessageWriter log;
    private final URI segmentIdentityUri;
    private final URI segmentTraceUri;
    private final int timeoutMs = PropertyUtils.getProperty("quarkus.analytics.timeout", 3000);

    static URI getUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static String getAuthHeader(String key) {
        String auth = key + ":";
        return "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.ISO_8859_1));
    }

    public RestClient(MessageWriter log) {
        this.log = log;
        String segmentBaseUri = PropertyUtils.getProperty("quarkus.analytics.uri.base", "https://api.segment.io/");
        this.segmentIdentityUri = RestClient.getUri(segmentBaseUri + IDENTITY_ENDPOINT);
        this.segmentTraceUri = RestClient.getUri(segmentBaseUri + TRACK_ENDPOINT);
    }

    public RestClient() {
        this(MessageWriter.info());
    }

    @Override
    public CompletableFuture<HttpResponse<String>> postIdentity(Identity identity) {
        return this.post(identity, this.segmentIdentityUri);
    }

    @Override
    public CompletableFuture<HttpResponse<String>> postTrack(Track track) {
        return this.post(track, this.segmentTraceUri);
    }

    @Override
    public Optional<AnalyticsRemoteConfig> getConfig() {
        return this.getConfig(CONFIG_URI);
    }

    Optional<AnalyticsRemoteConfig> getConfig(URI uri) {
        try {
            HttpClient httpClient = this.createHttpClient();
            HttpRequest request = this.createRequest(uri).GET().build();
            CompletableFuture<HttpResponse<String>> responseFuture = httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            HttpResponse<String> response = responseFuture.get(this.timeoutMs, TimeUnit.MILLISECONDS);
            int statusCode = response.statusCode();
            if (statusCode == 200) {
                String body = response.body();
                return Optional.of((AnalyticsRemoteConfig)StringUtils.getObjectMapper().readValue(body, RemoteConfig.class));
            }
            return Optional.empty();
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            this.log.warn("[Quarkus build analytics] Analytics remote config not received. " + e.getClass().getName() + ": " + (e.getMessage() == null ? "(no message)" : e.getMessage()));
            return Optional.empty();
        }
    }

    CompletableFuture<HttpResponse<String>> post(Serializable payload, URI url) {
        try {
            HttpClient httpClient = this.createHttpClient();
            String toSend = StringUtils.getObjectMapper().writeValueAsString((Object)payload);
            if (this.log.isDebugEnabled()) {
                this.log.debug("[Quarkus build analytics] Analytics to send: " + toSend);
            }
            HttpRequest request = this.createRequest(url).POST(HttpRequest.BodyPublishers.ofString(toSend)).build();
            return httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            this.log.warn("[Quarkus build analytics] Analytics not sent. " + e.getMessage());
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpClient createHttpClient() {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).connectTimeout(Duration.ofMillis(this.timeoutMs)).build();
    }

    private HttpRequest.Builder createRequest(URI uri) {
        return HttpRequest.newBuilder(uri).header("authorization", AUTH_HEADER).header("accept", "application/json").header("content-type", "application/json").timeout(Duration.ofMillis(this.timeoutMs));
    }
}

