/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class ExecUtil {
    private static final Logger LOG = Logger.getLogger(ExecUtil.class);
    private static final Function<InputStream, Runnable> PRINT_OUTPUT = i -> new HandleOutput((InputStream)i);
    private static final Function<InputStream, Runnable> SILENT = i -> new HandleOutput((InputStream)i, false);

    public static boolean exec(String command, String ... args) {
        return ExecUtil.exec(new File("."), command, args);
    }

    public static boolean execSilent(String command, String ... args) {
        return ExecUtil.execSilent(new File("."), command, args);
    }

    public static boolean exec(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, PRINT_OUTPUT, command, args);
    }

    public static boolean execSilent(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, SILENT, command, args);
    }

    public static boolean exec(File directory, Function<InputStream, Runnable> outputFilterFunction, String command, String ... args) {
        Process process = null;
        try {
            String[] cmd = new String[args.length + 1];
            cmd[0] = command;
            if (args.length > 0) {
                System.arraycopy(args, 0, cmd, 1, args.length);
            }
            process = new ProcessBuilder(new String[0]).directory(directory).command(cmd).redirectErrorStream(true).start();
            outputFilterFunction.apply(process.getInputStream()).run();
            process.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
        catch (InterruptedException e) {
            return false;
        }
        return process != null && process.exitValue() == 0;
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final Boolean logEnabled;

        HandleOutput(InputStream is) {
            this(is, true);
        }

        HandleOutput(InputStream is, Boolean logEnabled) {
            this.is = is;
            this.logEnabled = logEnabled;
        }

        @Override
        public void run() {
            try (InputStreamReader isr = new InputStreamReader(this.is);
                 BufferedReader reader = new BufferedReader(isr);){
                String line = reader.readLine();
                while (line != null) {
                    if (this.logEnabled.booleanValue()) {
                        LOG.info((Object)line);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

