/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassFinalFieldsWritablePredicateBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.jboss.jandex.VoidType;
import org.jboss.logging.Logger;

public class ReflectiveHierarchyStep {
    private static final Logger log = Logger.getLogger(ReflectiveHierarchyStep.class);

    @BuildStep
    public ReflectiveHierarchyIgnoreWarningBuildItem ignoreJavaClassWarnings() {
        return new ReflectiveHierarchyIgnoreWarningBuildItem(ReflectiveHierarchyBuildItem.IgnoreWhiteListedPredicate.INSTANCE);
    }

    @BuildStep
    public void build(CombinedIndexBuildItem combinedIndexBuildItem, List<ReflectiveHierarchyBuildItem> hierarchy, List<ReflectiveHierarchyIgnoreWarningBuildItem> ignored, List<ReflectiveClassFinalFieldsWritablePredicateBuildItem> finalFieldsWritablePredicates, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws Exception {
        HashSet<DotName> processedReflectiveHierarchies = new HashSet<DotName>();
        TreeMap<DotName, Set<String>> unindexedClasses = new TreeMap<DotName, Set<String>>();
        Predicate finalFieldsWritable = c -> false;
        if (!finalFieldsWritablePredicates.isEmpty()) {
            finalFieldsWritable = finalFieldsWritablePredicates.stream().map(ReflectiveClassFinalFieldsWritablePredicateBuildItem::getPredicate).reduce(c -> false, Predicate::or);
        }
        for (ReflectiveHierarchyBuildItem i : hierarchy) {
            this.addReflectiveHierarchy(combinedIndexBuildItem, i, i.hasSource() ? i.getSource() : i.getType().name().toString(), i.getType(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
        }
        this.removeIgnored(unindexedClasses, ignored);
        if (!unindexedClasses.isEmpty()) {
            StringBuilder unindexedClassesWarn = new StringBuilder();
            for (Map.Entry unindexedClassEntry : unindexedClasses.entrySet()) {
                if (unindexedClassesWarn.length() != 0) {
                    unindexedClassesWarn.append("\n");
                }
                unindexedClassesWarn.append("\t- ").append(unindexedClassEntry.getKey());
                unindexedClassesWarn.append(" (source");
                if (((Set)unindexedClassEntry.getValue()).size() > 1) {
                    unindexedClassesWarn.append("s");
                }
                unindexedClassesWarn.append(": ");
                unindexedClassesWarn.append(String.join((CharSequence)", ", ((Set)unindexedClassEntry.getValue()).toArray(new String[0])));
                unindexedClassesWarn.append(")");
            }
            log.warnf("Unable to properly register the hierarchy of the following classes for reflection as they are not in the Jandex index:%n%s%nConsider adding them to the index either by creating a Jandex index for your dependency via the Maven plugin, an empty META-INF/beans.xml or quarkus.index-dependency properties.\");.", (Object)unindexedClassesWarn.toString());
        }
    }

    private void removeIgnored(Map<DotName, Set<String>> unindexedClasses, List<ReflectiveHierarchyIgnoreWarningBuildItem> ignored) {
        if (ignored.isEmpty()) {
            return;
        }
        Predicate finalPredicate = ignored.stream().map(ReflectiveHierarchyIgnoreWarningBuildItem::getPredicate).reduce(x -> false, Predicate::or);
        HashSet<DotName> unindexedDotNames = new HashSet<DotName>(unindexedClasses.keySet());
        for (DotName unindexedDotName : unindexedDotNames) {
            if (!finalPredicate.test(unindexedDotName)) continue;
            unindexedClasses.remove(unindexedDotName);
        }
    }

    private void addReflectiveHierarchy(CombinedIndexBuildItem combinedIndexBuildItem, ReflectiveHierarchyBuildItem reflectiveHierarchyBuildItem, String source, Type type, Set<DotName> processedReflectiveHierarchies, Map<DotName, Set<String>> unindexedClasses, Predicate<ClassInfo> finalFieldsWritable, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        block7: {
            block8: {
                block6: {
                    if (type instanceof VoidType || type instanceof PrimitiveType || type instanceof UnresolvedTypeVariable) {
                        return;
                    }
                    if (!(type instanceof ClassType)) break block6;
                    if (reflectiveHierarchyBuildItem.getIgnoreTypePredicate().test(type.name())) {
                        return;
                    }
                    this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, type.name(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
                    for (ClassInfo subclass : combinedIndexBuildItem.getIndex().getAllKnownSubclasses(type.name())) {
                        this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, subclass.name(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
                    }
                    for (ClassInfo subclass : combinedIndexBuildItem.getIndex().getAllKnownImplementors(type.name())) {
                        this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, subclass.name(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
                    }
                    break block7;
                }
                if (!(type instanceof ArrayType)) break block8;
                this.addReflectiveHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, type.asArrayType().component(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
                break block7;
            }
            if (!(type instanceof ParameterizedType)) break block7;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!reflectiveHierarchyBuildItem.getIgnoreTypePredicate().test(parameterizedType.name())) {
                this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, parameterizedType.name(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
            }
            for (Type typeArgument : parameterizedType.arguments()) {
                this.addReflectiveHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, typeArgument, processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
            }
        }
    }

    private void addClassTypeHierarchy(CombinedIndexBuildItem combinedIndexBuildItem, ReflectiveHierarchyBuildItem reflectiveHierarchyBuildItem, String source, DotName name, Set<DotName> processedReflectiveHierarchies, Map<DotName, Set<String>> unindexedClasses, Predicate<ClassInfo> finalFieldsWritable, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (name == null) {
            return;
        }
        if (reflectiveHierarchyBuildItem.getIgnoreTypePredicate().test(name)) {
            return;
        }
        ClassInfo info = (reflectiveHierarchyBuildItem.getIndex() != null ? reflectiveHierarchyBuildItem.getIndex() : combinedIndexBuildItem.getIndex()).getClassByName(name);
        if (info == null) {
            unindexedClasses.putIfAbsent(name, new TreeSet());
            unindexedClasses.get(name).add(source);
        }
        if (processedReflectiveHierarchies.contains(name)) {
            return;
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(name.toString()).methods(true).fields(true).finalFieldsWritable(this.doFinalFieldsNeedToBeWritable(info, finalFieldsWritable)).build());
        processedReflectiveHierarchies.add(name);
        if (info == null) {
            return;
        }
        this.addClassTypeHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, info.superName(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
        for (FieldInfo field : info.fields()) {
            if (reflectiveHierarchyBuildItem.getIgnoreFieldPredicate().test(field) || Modifier.isStatic(field.flags()) || field.name().startsWith("this$") || field.name().startsWith("val$")) continue;
            this.addReflectiveHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, field.type(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
        }
        for (MethodInfo method : info.methods()) {
            if (reflectiveHierarchyBuildItem.getIgnoreMethodPredicate().test(method) || method.parameters().size() > 0 || Modifier.isStatic(method.flags()) || method.returnType().kind() == Type.Kind.VOID) continue;
            this.addReflectiveHierarchy(combinedIndexBuildItem, reflectiveHierarchyBuildItem, source, method.returnType(), processedReflectiveHierarchies, unindexedClasses, finalFieldsWritable, reflectiveClass);
        }
    }

    private boolean doFinalFieldsNeedToBeWritable(ClassInfo classInfo, Predicate<ClassInfo> finalFieldsWritable) {
        if (classInfo == null) {
            return false;
        }
        return finalFieldsWritable.test(classInfo);
    }
}

