/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.PreloadClassBuildItem;
import io.quarkus.deployment.builditem.PreloadClassesEnabledBuildItem;
import io.quarkus.runtime.PreloadClassesRecorder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PreloadClassesBuildStep {
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void preInit(Optional<PreloadClassesEnabledBuildItem> preload, PreloadClassesRecorder recorder) {
        if (!preload.isPresent()) {
            return;
        }
        recorder.invokePreloadClasses(preload.get().doInitialize());
    }

    @BuildStep
    public GeneratedResourceBuildItem registerPreInitClasses(List<PreloadClassBuildItem> items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        String names = items.stream().map(PreloadClassBuildItem::getClassName).sorted().distinct().map(s -> s.concat(System.lineSeparator())).collect(Collectors.joining());
        return new GeneratedResourceBuildItem("META-INF/quarkus-generated-preload-classes.txt", names.getBytes(StandardCharsets.UTF_8));
    }
}

