/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigInstantiator {
    private static Set<String> supportedClassNameSuffix;

    public static void handleObject(Object o) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        Class<?> cls = o.getClass();
        String clsNameSuffix = ConfigInstantiator.getClassNameSuffix(o);
        if (clsNameSuffix == null) {
            return;
        }
        String name = ConfigInstantiator.dashify(cls.getSimpleName().substring(0, cls.getSimpleName().length() - clsNameSuffix.length()));
        ConfigInstantiator.handleObject("quarkus." + name, o, config);
    }

    private static void handleObject(String prefix, Object o, SmallRyeConfig config) {
        try {
            Class<?> cls = o.getClass();
            if (!ConfigInstantiator.isClassNameSuffixSupported(o)) {
                return;
            }
            for (Field field : cls.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isFinal(field.getModifiers())) continue;
                field.setAccessible(true);
                ConfigItem configItem = field.getDeclaredAnnotation(ConfigItem.class);
                Class<?> fieldClass = field.getType();
                if (configItem == null || fieldClass.isAnnotationPresent(ConfigGroup.class)) {
                    Constructor<?> constructor = fieldClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    Object newInstance = constructor.newInstance(new Object[0]);
                    field.set(o, newInstance);
                    ConfigInstantiator.handleObject(prefix + "." + ConfigInstantiator.dashify(field.getName()), newInstance, config);
                    continue;
                }
                if (fieldClass == Map.class) {
                    field.set(o, new HashMap());
                    continue;
                }
                String name = configItem.name();
                if (name.equals("<<hyphenated element name>>")) {
                    name = ConfigInstantiator.dashify(field.getName());
                } else if (name.equals("<<element name>>")) {
                    name = field.getName();
                }
                String fullName = prefix + "." + name;
                Type genericType = field.getGenericType();
                Converter<?> conv = ConfigInstantiator.getConverterFor(genericType);
                try {
                    Optional value = config.getOptionalValue(fullName, conv);
                    if (value.isPresent()) {
                        field.set(o, value.get());
                        continue;
                    }
                    if (configItem.defaultValue().equals("<<no default>>")) continue;
                    field.set(o, conv.convert(configItem.defaultValue()));
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Converter<?> getConverterFor(Type type) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        Class<?> rawType = ConfigInstantiator.rawTypeOf(type);
        if (Enum.class.isAssignableFrom(rawType)) {
            return new HyphenateEnumConverter(rawType);
        }
        if (rawType == Optional.class) {
            return Converters.newOptionalConverter(ConfigInstantiator.getConverterFor(ConfigInstantiator.typeOfParameter(type, 0)));
        }
        if (rawType == List.class) {
            return Converters.newCollectionConverter(ConfigInstantiator.getConverterFor(ConfigInstantiator.typeOfParameter(type, 0)), ArrayList::new);
        }
        return config.requireConverter(ConfigInstantiator.rawTypeOf(type));
    }

    private static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigInstantiator.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigInstantiator.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Type has no raw type class: " + type);
    }

    static Type typeOfParameter(Type type, int paramIdx) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[paramIdx];
        }
        throw new IllegalArgumentException("Type is not parameterized: " + type);
    }

    private static String dashify(String substring) {
        StringBuilder ret = new StringBuilder();
        char[] chars = substring.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i != 0 && i != chars.length - 1 && c >= 'A' && c <= 'Z') {
                ret.append('-');
            }
            ret.append(Character.toLowerCase(c));
        }
        return ret.toString();
    }

    private static String getClassNameSuffix(Object o) {
        if (o == null) {
            return null;
        }
        String klassName = o.getClass().getName();
        for (String supportedSuffix : supportedClassNameSuffix) {
            if (!klassName.endsWith(supportedSuffix)) continue;
            return supportedSuffix;
        }
        return null;
    }

    private static boolean isClassNameSuffixSupported(Object o) {
        if (o == null) {
            return false;
        }
        String klassName = o.getClass().getName();
        for (String supportedSuffix : supportedClassNameSuffix) {
            if (!klassName.endsWith(supportedSuffix)) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<String> suffixes = new HashSet<String>();
        suffixes.add("Config");
        suffixes.add("Configuration");
        supportedClassNameSuffix = Collections.unmodifiableSet(suffixes);
    }
}

