/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.init;

import io.quarkus.runtime.PreventFurtherStepsException;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.init.InitRuntimeConfig;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Recorder
public class InitializationTaskRecorder {
    private final InitRuntimeConfig initRuntimeConfig;

    public InitializationTaskRecorder(InitRuntimeConfig initRuntimeConfig) {
        this.initRuntimeConfig = initRuntimeConfig;
    }

    public void exitIfNeeded() {
        if (this.initRuntimeConfig.initAndExit()) {
            InitializationTaskRecorder.preventFurtherRecorderSteps(5, "Error attempting to gracefully shutdown after initialization", () -> new PreventFurtherStepsException("Gracefully exiting after initialization.", 0));
        }
    }

    public static void preventFurtherRecorderSteps(int waitSeconds, String waitErrorMessage, Supplier<PreventFurtherStepsException> supplier) {
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Quarkus.blockingExit();
                latch.countDown();
            }
        }).start();
        try {
            latch.await(waitSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.err.println(waitErrorMessage);
        }
        throw supplier.get();
    }
}

