/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.reader;

import io.quarkus.devtools.codestarts.CodestartResource;
import io.quarkus.devtools.codestarts.core.reader.IgnoreCodestartFileReader;
import io.quarkus.devtools.codestarts.core.reader.QuteCodestartFileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface CodestartFileReader {
    public static final CodestartFileReader DEFAULT = new DefaultCodestartFileReader();
    public static final List<CodestartFileReader> ALL = Collections.unmodifiableList(Arrays.asList(DEFAULT, new QuteCodestartFileReader(), new IgnoreCodestartFileReader()));

    public boolean matches(String var1);

    public String cleanFileName(String var1);

    public Optional<String> read(CodestartResource.Source var1, String var2, Map<String, Object> var3) throws IOException;

    public static class DefaultCodestartFileReader
    implements CodestartFileReader {
        @Override
        public boolean matches(String fileName) {
            return false;
        }

        @Override
        public String cleanFileName(String fileName) {
            return fileName.replace("..", ".");
        }

        @Override
        public Optional<String> read(CodestartResource.Source source, String languageName, Map<String, Object> data) throws IOException {
            return Optional.of(source.read());
        }
    }
}

