/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.extension;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.devtools.codestarts.DataKey;
import io.quarkus.devtools.codestarts.core.GenericCodestartCatalog;
import io.quarkus.devtools.codestarts.extension.QuarkusExtensionCodestartProjectInput;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class QuarkusExtensionCodestartCatalog
extends GenericCodestartCatalog<QuarkusExtensionCodestartProjectInput> {
    public static final String QUARKUS_EXTENSION_CODESTARTS_DIR = "codestarts/quarkus-extension";

    private QuarkusExtensionCodestartCatalog(Collection<Codestart> codestarts) {
        super(codestarts);
    }

    public static QuarkusExtensionCodestartCatalog fromBaseCodestartsResources() throws IOException {
        Map<String, Codestart> codestarts = CodestartResourceLoader.loadCodestartsFromResources(CodestartResourceLoadersBuilder.getCodestartResourceLoaders(), QUARKUS_EXTENSION_CODESTARTS_DIR);
        return new QuarkusExtensionCodestartCatalog(codestarts.values());
    }

    protected Collection<Codestart> select(QuarkusExtensionCodestartProjectInput projectInput) {
        projectInput.getSelection().addNames(this.getCodestarts(projectInput));
        return super.select((CodestartProjectInput)projectInput);
    }

    private List<String> getCodestarts(QuarkusExtensionCodestartProjectInput projectInput) {
        ArrayList<String> codestarts = new ArrayList<String>();
        codestarts.add(Code.EXTENSION_BASE.key());
        if (!projectInput.withoutDevModeTest()) {
            codestarts.add(Code.DEVMODE_TEST.key());
        }
        if (!projectInput.withoutIntegrationTests()) {
            codestarts.add(Code.INTEGRATION_TESTS.key());
        }
        if (!projectInput.withoutUnitTest()) {
            codestarts.add(Code.UNIT_TEST.key());
        }
        return codestarts;
    }

    public static enum Tooling implements DataKey
    {
        GIT;

    }

    public static enum Code implements DataKey
    {
        EXTENSION_BASE,
        QUARKIVERSE,
        DEVMODE_TEST,
        INTEGRATION_TESTS,
        UNIT_TEST;

    }

    public static enum QuarkusExtensionData implements DataKey
    {
        NAMESPACE_ID("namespace.id"),
        NAMESPACE_NAME("namespace.name"),
        EXTENSION_ID("extension.id"),
        EXTENSION_NAME("extension.name"),
        EXTENSION_FULL_NAME("extension.full-name"),
        EXTENSION_DESCRIPTION("extension.description"),
        EXTENSION_GUIDE("extension.guide"),
        GROUP_ID("group-id"),
        VERSION("version"),
        PACKAGE_NAME("package-name"),
        CLASS_NAME_BASE("class-name-base"),
        MAVEN_SUREFIRE_PLUGIN_VERSION("maven.surefire-plugin.version"),
        QUARKUS_VERSION("quarkus.version"),
        QUARKUS_BOM_GROUP_ID("quarkus.bom.group-id"),
        QUARKUS_BOM_ARTIFACT_ID("quarkus.bom.artifact-id"),
        QUARKUS_BOM_VERSION("quarkus.bom.version"),
        PROPERTIES_FROM_PARENT("properties.from-parent"),
        PARENT_GROUP_ID("parent.group-id"),
        PARENT_ARTIFACT_ID("parent.artifact-id"),
        PARENT_VERSION("parent.version"),
        PARENT_RELATIVE_PATH("parent.relative-path"),
        IT_PARENT_GROUP_ID("it-parent.group-id"),
        IT_PARENT_ARTIFACT_ID("it-parent.artifact-id"),
        IT_PARENT_VERSION("it-parent.version"),
        IT_PARENT_RELATIVE_PATH("it-parent.relative-path"),
        MAVEN_QUARKUS_EXTENSION_PLUGIN("maven.quarkus-extension-plugin"),
        MAVEN_COMPILER_PLUGIN_VERSION("maven.compiler-plugin-version"),
        HAS_DOCS_MODULE("has-docs-module");

        private final String key;

        private QuarkusExtensionData(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

