/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.ldap;

import io.quarkus.elytron.security.ldap.QuarkusDirContextFactory;
import io.quarkus.elytron.security.ldap.config.AttributeMappingConfig;
import io.quarkus.elytron.security.ldap.config.DirContextConfig;
import io.quarkus.elytron.security.ldap.config.IdentityMappingConfig;
import io.quarkus.elytron.security.ldap.config.LdapSecurityRealmRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.SecurityRealm;

@Recorder
public class LdapRecorder {
    public RuntimeValue<SecurityRealm> createRealm(LdapSecurityRealmRuntimeConfig runtimeConfig) {
        LdapSecurityRealmBuilder.IdentityMappingBuilder identityMappingBuilder = LdapSecurityRealmBuilder.builder().setDirContextSupplier(this.createDirContextSupplier(runtimeConfig.dirContext)).identityMapping();
        if (runtimeConfig.identityMapping.searchRecursive) {
            identityMappingBuilder.searchRecursive();
        }
        LdapSecurityRealmBuilder ldapSecurityRealmBuilder = identityMappingBuilder.map(this.createAttributeMappings(runtimeConfig.identityMapping)).setRdnIdentifier(runtimeConfig.identityMapping.rdnIdentifier).setSearchDn(runtimeConfig.identityMapping.searchBaseDn).build();
        if (runtimeConfig.directVerification) {
            ldapSecurityRealmBuilder.addDirectEvidenceVerification(false);
        }
        return new RuntimeValue((Object)ldapSecurityRealmBuilder.build());
    }

    private ExceptionSupplier<DirContext, NamingException> createDirContextSupplier(DirContextConfig dirContext) {
        QuarkusDirContextFactory dirContextFactory = new QuarkusDirContextFactory(dirContext.url, dirContext.principal.orElse(null), dirContext.password.orElse(null), dirContext.connectTimeout, dirContext.readTimeout);
        return () -> dirContextFactory.obtainDirContext(dirContext.referralMode);
    }

    private AttributeMapping[] createAttributeMappings(IdentityMappingConfig identityMappingConfig) {
        ArrayList<AttributeMapping> attributeMappings = new ArrayList<AttributeMapping>();
        for (AttributeMappingConfig attributeMappingConfig : identityMappingConfig.attributeMappings.values()) {
            attributeMappings.add(AttributeMapping.fromFilter((String)attributeMappingConfig.filter).from(attributeMappingConfig.from).to(attributeMappingConfig.to).searchDn(attributeMappingConfig.filterBaseDn).build());
        }
        AttributeMapping[] attributeMappingsArray = new AttributeMapping[attributeMappings.size()];
        return attributeMappings.toArray(attributeMappingsArray);
    }
}

