/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.deployment.ImpliedBlockingPersistenceUnitTypeBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;

public class HibernateOrmCdiProcessor {
    private static final List<DotName> SESSION_FACTORY_EXPOSED_TYPES = Arrays.asList(DotName.createSimple((String)EntityManagerFactory.class.getName()), DotName.createSimple((String)SessionFactory.class.getName()));
    private static final List<DotName> SESSION_EXPOSED_TYPES = Arrays.asList(DotName.createSimple((String)EntityManager.class.getName()), DotName.createSimple((String)Session.class.getName()));
    private static final DotName PERSISTENCE_UNIT_QUALIFIER = DotName.createSimple((String)PersistenceUnit.class.getName());
    private static final DotName JPA_PERSISTENCE_UNIT = DotName.createSimple((String)javax.persistence.PersistenceUnit.class.getName());
    private static final DotName JPA_PERSISTENCE_CONTEXT = DotName.createSimple((String)PersistenceContext.class.getName());

    @BuildStep
    AnnotationsTransformerBuildItem convertJpaResourceAnnotationsToQualifier(final List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, final ImpliedBlockingPersistenceUnitTypeBuildItem impliedBlockingPersistenceUnitType) {
        AnnotationsTransformer transformer = new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                DotName jpaAnnotation;
                FieldInfo field = transformationContext.getTarget().asField();
                DotName fieldTypeName = field.type().name();
                if (!SESSION_EXPOSED_TYPES.contains(fieldTypeName) && !SESSION_FACTORY_EXPOSED_TYPES.contains(fieldTypeName)) {
                    return;
                }
                if (field.hasAnnotation(JPA_PERSISTENCE_UNIT)) {
                    jpaAnnotation = JPA_PERSISTENCE_UNIT;
                } else if (field.hasAnnotation(JPA_PERSISTENCE_CONTEXT)) {
                    jpaAnnotation = JPA_PERSISTENCE_CONTEXT;
                } else {
                    return;
                }
                AnnotationValue persistenceUnitNameAnnotationValue = field.annotation(jpaAnnotation).value("unitName");
                Transformation transformation = (Transformation)transformationContext.transform().add(DotNames.INJECT, new AnnotationValue[0]);
                if (persistenceUnitNameAnnotationValue == null || persistenceUnitNameAnnotationValue.asString().isEmpty()) {
                    transformation.add(DotNames.DEFAULT, new AnnotationValue[0]);
                } else if (persistenceUnitDescriptors.size() == 1 && !impliedBlockingPersistenceUnitType.shouldGenerateImpliedBlockingPersistenceUnit() && ((PersistenceUnitDescriptorBuildItem)((Object)persistenceUnitDescriptors.get(0))).getPersistenceUnitName().equals(persistenceUnitNameAnnotationValue.asString())) {
                    transformation.add(DotNames.DEFAULT, new AnnotationValue[0]);
                } else {
                    transformation.add(PERSISTENCE_UNIT_QUALIFIER, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)persistenceUnitNameAnnotationValue.asString())});
                }
                transformation.done();
            }
        };
        return new AnnotationsTransformerBuildItem(transformer);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void generateDataSourceBeans(HibernateOrmRecorder recorder, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, ImpliedBlockingPersistenceUnitTypeBuildItem impliedBlockingPersistenceUnitType, List<JdbcDataSourceBuildItem> jdbcDataSources, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (persistenceUnitDescriptors.isEmpty()) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(PersistenceUnit.class).build());
        if (persistenceUnitDescriptors.size() == 1 && !impliedBlockingPersistenceUnitType.shouldGenerateImpliedBlockingPersistenceUnit()) {
            String persistenceUnitName = persistenceUnitDescriptors.get(0).getPersistenceUnitName();
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, true, SessionFactory.class, SESSION_FACTORY_EXPOSED_TYPES, recorder.sessionFactorySupplier(persistenceUnitName), true));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, true, Session.class, SESSION_EXPOSED_TYPES, recorder.sessionSupplier(persistenceUnitName), false));
            return;
        }
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : persistenceUnitDescriptors) {
            String persistenceUnitName = persistenceUnitDescriptor.getPersistenceUnitName();
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName), SessionFactory.class, SESSION_FACTORY_EXPOSED_TYPES, recorder.sessionFactorySupplier(persistenceUnitName), true));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName), Session.class, SESSION_EXPOSED_TYPES, recorder.sessionSupplier(persistenceUnitName), false));
        }
    }

    private static <T> SyntheticBeanBuildItem createSyntheticBean(String persistenceUnitName, boolean isDefaultPersistenceUnit, Class<T> type, List<DotName> allExposedTypes, Supplier<T> supplier, boolean defaultBean) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).scope(Singleton.class)).unremovable()).supplier(supplier);
        for (DotName exposedType : allExposedTypes) {
            configurator.addType(exposedType);
        }
        if (defaultBean) {
            configurator.defaultBean();
        }
        if (isDefaultPersistenceUnit) {
            configurator.addQualifier(Default.class);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)persistenceUnitName).done();
            configurator.addQualifier().annotation(PersistenceUnit.class).addValue("value", (Object)persistenceUnitName).done();
        }
        return configurator.done();
    }
}

