/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.proxies;

import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.bytebuddy.ClassFileVersion;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.proxy.pojo.ProxyFactoryHelper;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;
import org.jboss.logging.Logger;

public final class ProxyDefinitions {
    private final Map<Class<?>, ProxyClassDetailsHolder> proxyDefinitionMap;
    private static final Logger LOGGER = Logger.getLogger((String)ProxyDefinitions.class.getName());

    private ProxyDefinitions(Map<Class<?>, ProxyClassDetailsHolder> proxyDefinitionMap) {
        this.proxyDefinitionMap = proxyDefinitionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProxyDefinitions createFromMetadata(Metadata storeableMetadata, PreGeneratedProxies preGeneratedProxies) {
        LazyBytecode lazyBytecode = new LazyBytecode();
        if (!ProxyDefinitions.needAnyProxyDefinitions(storeableMetadata)) return new ProxyDefinitions(Collections.emptyMap());
        HashMap proxyDefinitionMap = new HashMap();
        try {
            for (PersistentClass persistentClass : storeableMetadata.getEntityBindings()) {
                if (!ProxyDefinitions.needsProxyGeneration(persistentClass)) continue;
                Class mappedClass = persistentClass.getMappedClass();
                Class<?> proxyClassDefinition = ProxyDefinitions.generateProxyClass(persistentClass, lazyBytecode, preGeneratedProxies);
                if (proxyClassDefinition == null) continue;
                boolean overridesEquals = ReflectHelper.overridesEquals((Class)mappedClass);
                try {
                    proxyDefinitionMap.put(mappedClass, new ProxyClassDetailsHolder(overridesEquals, proxyClassDefinition.getConstructor(new Class[0])));
                }
                catch (NoSuchMethodException e) {
                    throw new HibernateException("Failed to generate Enhanced Proxy: default constructor is missing for entity '" + mappedClass.getName() + "'. Please add a default constructor explicitly.");
                    return new ProxyDefinitions(proxyDefinitionMap);
                }
            }
        }
        finally {
            lazyBytecode.close();
        }
    }

    private static boolean needAnyProxyDefinitions(Metadata storeableMetadata) {
        for (PersistentClass persistentClass : storeableMetadata.getEntityBindings()) {
            if (!ProxyDefinitions.needsProxyGeneration(persistentClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsProxyGeneration(PersistentClass persistentClass) {
        return persistentClass.isLazy() && persistentClass.getMappedClass() != null;
    }

    private static Class<?> generateProxyClass(PersistentClass persistentClass, Supplier<ByteBuddyProxyHelper> byteBuddyProxyHelper, PreGeneratedProxies preGeneratedProxies) {
        String entityName = persistentClass.getEntityName();
        Class mappedClass = persistentClass.getMappedClass();
        if (Modifier.isFinal(mappedClass.getModifiers())) {
            LOGGER.warn((Object)("Could not generate an enhanced proxy for entity '" + entityName + "' (class='" + mappedClass.getCanonicalName() + "') as it's final. Your application might perform better if we're allowed to extend it."));
            return null;
        }
        Set proxyInterfaces = ProxyFactoryHelper.extractProxyInterfaces((PersistentClass)persistentClass, (String)entityName);
        PreGeneratedProxies.ProxyClassDetailsHolder preProxy = preGeneratedProxies.getProxies().get(persistentClass.getClassName());
        Class<?> preGeneratedProxy = null;
        boolean match = true;
        if (preProxy != null) {
            boolean bl = match = proxyInterfaces.size() == preProxy.getProxyInterfaces().size();
            if (match) {
                for (Class i : proxyInterfaces) {
                    if (preProxy.getProxyInterfaces().contains(i.getName())) continue;
                    match = false;
                    break;
                }
            }
            if (match) {
                try {
                    preGeneratedProxy = Class.forName(preProxy.getClassName(), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to load proxy class", e);
                }
            }
        }
        if (preGeneratedProxy == null) {
            if (match) {
                LOGGER.warnf("Unable to find a build time generated proxy for entity %s", (Object)persistentClass.getClassName());
            } else {
                LOGGER.errorf("Unable to use a build time generated proxy for entity %s, as the build time proxy interfaces %s are different to the runtime ones %s. This should not happen, please open an issue at https://github.com/quarkusio/quarkus/issues", (Object)persistentClass.getClassName(), preProxy.getProxyInterfaces(), (Object)proxyInterfaces);
            }
            Class proxyDef = byteBuddyProxyHelper.get().buildProxy(mappedClass, ProxyDefinitions.toArray(proxyInterfaces));
            return proxyDef;
        }
        return preGeneratedProxy;
    }

    private static Class[] toArray(Set<Class> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public ProxyClassDetailsHolder getProxyForClass(Class persistentClass) {
        return this.proxyDefinitionMap.get(persistentClass);
    }

    private static final class LazyBytecode
    implements Supplier<ByteBuddyProxyHelper> {
        ByteBuddyProxyHelper helper;
        private BytecodeProviderImpl bytecodeProvider;

        private LazyBytecode() {
        }

        @Override
        public ByteBuddyProxyHelper get() {
            if (this.helper == null) {
                this.bytecodeProvider = new BytecodeProviderImpl(ClassFileVersion.JAVA_V8);
                this.helper = this.bytecodeProvider.getByteBuddyProxyHelper();
            }
            return this.helper;
        }

        void close() {
            if (this.bytecodeProvider != null) {
                this.bytecodeProvider.resetCaches();
            }
        }
    }

    public static class ProxyClassDetailsHolder {
        private final boolean overridesEquals;
        private final Constructor constructor;

        private ProxyClassDetailsHolder(boolean overridesEquals, Constructor constructor) {
            this.overridesEquals = overridesEquals;
            this.constructor = constructor;
        }

        public boolean isOverridesEquals() {
            return this.overridesEquals;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }
    }
}

