/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.locale;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolverContext;

abstract class AbstractLocaleResolver
implements LocaleResolver {
    AbstractLocaleResolver() {
    }

    protected abstract Map<String, List<String>> getHeaders();

    public Locale resolve(LocaleResolverContext context) {
        Optional<List<Locale.LanguageRange>> localePriorities = this.getAcceptableLanguages();
        if (!localePriorities.isPresent()) {
            return null;
        }
        List<Locale> resolvedLocales = Locale.filter(localePriorities.get(), context.getSupportedLocales());
        if (resolvedLocales.size() > 0) {
            return resolvedLocales.get(0);
        }
        return null;
    }

    private Optional<List<Locale.LanguageRange>> getAcceptableLanguages() {
        List<String> acceptLanguageList;
        Map<String, List<String>> httpHeaders = this.getHeaders();
        if (httpHeaders != null && (acceptLanguageList = httpHeaders.get("Accept-Language")) != null && !acceptLanguageList.isEmpty()) {
            return Optional.of(Locale.LanguageRange.parse(acceptLanguageList.get(0)));
        }
        return Optional.empty();
    }
}

