/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.h2.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StatefulDataType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public final class H2JDBCReflections {
    @BuildStep
    void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        String driverName = "org.h2.Driver";
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.h2.Driver"}));
    }

    @BuildStep
    NativeImageFeatureBuildItem enableH2Feature() {
        return new NativeImageFeatureBuildItem("io.quarkus.jdbc.h2.runtime.H2Reflections");
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    IndexDependencyBuildItem indexH2Library() {
        return new IndexDependencyBuildItem("com.h2database", "h2");
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    GeneratedResourceBuildItem listStatefulDataTypeFactories(CombinedIndexBuildItem index) {
        return H2JDBCReflections.generateListBy("h2StatefulDataType.classlist", index, i -> i.getAllKnownImplementors(StatefulDataType.Factory.class).stream());
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    GeneratedResourceBuildItem listBasicDataTypes(CombinedIndexBuildItem index) {
        return H2JDBCReflections.generateListBy("h2BasicDataTypeSingletons.classlist", index, i -> i.getAllKnownImplementors(DataType.class).stream().filter(classInfo -> classInfo.field("INSTANCE") != null));
    }

    private static GeneratedResourceBuildItem generateListBy(String resourceName, CombinedIndexBuildItem index, Function<IndexView, Stream<ClassInfo>> selection) {
        String classNames = selection.apply(index.getIndex()).map(ClassInfo::name).map(DotName::toString).sorted().collect(Collectors.joining("\n"));
        return new GeneratedResourceBuildItem(resourceName, classNames.getBytes(StandardCharsets.UTF_8));
    }
}

