/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.internal;

import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class CustomListConverter
extends CollectionConverter {
    private final Predicate<String> supported = new Predicate<String>(){
        private final Set<String> JDK_LIST_CLASS_NAMES = Set.of(List.of().getClass().getName(), List.of(Integer.valueOf(Integer.MAX_VALUE)).getClass().getName(), Arrays.asList(Integer.MAX_VALUE).getClass().getName(), Collections.unmodifiableList(List.of()).getClass().getName(), Collections.emptyList().getClass().getName(), List.of(Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(Integer.MAX_VALUE)).subList(0, 1).getClass().getName());

        @Override
        public boolean test(String className) {
            return this.JDK_LIST_CLASS_NAMES.contains(className);
        }
    }.or(new Predicate<String>(){
        private static final String GUAVA_LISTS_PACKAGE = "com.google.common.collect.Lists";

        @Override
        public boolean test(String className) {
            return className.startsWith(GUAVA_LISTS_PACKAGE);
        }
    });

    public CustomListConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type != null && this.supported.test(type.getName());
    }

    protected Object createCollection(Class type) {
        return new ArrayList();
    }
}

