/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.devservices.common.ConfigureUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class KafkaNativeContainer
extends GenericContainer<KafkaNativeContainer> {
    private static final String STARTER_SCRIPT = "/work/run.sh";
    private final Integer fixedExposedPort;
    private final boolean useSharedNetwork;
    private String additionalArgs = null;
    private int exposedPort = -1;
    private String hostName = null;

    public KafkaNativeContainer(DockerImageName dockerImageName, int fixedExposedPort, String serviceName, boolean useSharedNetwork) {
        super(dockerImageName);
        this.fixedExposedPort = fixedExposedPort;
        this.useSharedNetwork = useSharedNetwork;
        if (serviceName != null) {
            this.withLabel("quarkus-dev-service-kafka", serviceName);
        }
        String cmd = String.format("while [ ! -f %s ]; do sleep 0.1; done; sleep 0.1; %s", STARTER_SCRIPT, STARTER_SCRIPT);
        this.withCommand(new String[]{"sh", "-c", cmd});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Kafka broker started.*", (int)1));
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        this.exposedPort = this.getMappedPort(9092);
        Object cmd = "#!/bin/bash\n";
        cmd = (String)cmd + "/work/kafka";
        cmd = (String)cmd + " -Dkafka.advertised.listeners=" + this.getBootstrapServers();
        if (this.useSharedNetwork) {
            cmd = (String)cmd + " -Dkafka.listeners=BROKER://:9093,PLAINTEXT://:9092,CONTROLLER://:9094";
            cmd = (String)cmd + " -Dkafka.interbroker.listener.name=BROKER";
            cmd = (String)cmd + " -Dkafka.controller.listener.names=CONTROLLER";
            cmd = (String)cmd + " -Dkafka.listener.security.protocol.map=BROKER:PLAINTEXT,CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT";
            cmd = (String)cmd + " -Dkafka.early.start.listeners=BROKER,CONTROLLER,PLAINTEXT";
        }
        if (this.additionalArgs != null) {
            cmd = (String)cmd + " " + this.additionalArgs;
        }
        this.copyFileToContainer(Transferable.of((byte[])((String)cmd).getBytes(StandardCharsets.UTF_8), (int)511), STARTER_SCRIPT);
    }

    private String getKafkaAdvertisedListeners() {
        ArrayList<String> addresses = new ArrayList<String>();
        if (this.useSharedNetwork) {
            addresses.add(String.format("BROKER://%s:9093", this.hostName));
        }
        addresses.add(String.format("PLAINTEXT://%s:%d", this.getHost(), this.getExposedKafkaPort()));
        return String.join((CharSequence)",", addresses);
    }

    public int getExposedKafkaPort() {
        return this.exposedPort;
    }

    protected void configure() {
        super.configure();
        this.addExposedPort(9092);
        this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"kafka");
        if (this.fixedExposedPort != null) {
            this.addFixedExposedPort(this.fixedExposedPort, 9092);
        }
    }

    public String getBootstrapServers() {
        return this.getKafkaAdvertisedListeners();
    }
}

