/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.runtime.AbstractJsonObjectResponse;
import jakarta.json.JsonObject;
import java.util.HashSet;
import java.util.Set;

public class TokenIntrospection
extends AbstractJsonObjectResponse {
    public TokenIntrospection() {
    }

    public TokenIntrospection(String introspectionJson) {
        super(introspectionJson);
    }

    public TokenIntrospection(JsonObject json) {
        super(json);
    }

    public boolean isActive() {
        return this.getBoolean("active");
    }

    public String getUsername() {
        return this.getString("username");
    }

    public String getSubject() {
        return this.getString("sub");
    }

    public String getAudience() {
        return this.getString("aud");
    }

    public String getIssuer() {
        return this.getString("iss");
    }

    public Set<String> getScopes() {
        if (this.contains("scope")) {
            String[] scopesArray = this.getString("scope").split(" ");
            HashSet<String> scopes = new HashSet<String>(scopesArray.length);
            for (String scope : scopesArray) {
                scopes.add(scope.trim());
            }
            return scopes;
        }
        return null;
    }

    public String getClientId() {
        return this.getString("client_id");
    }

    public String getIntrospectionString() {
        return this.getNonNullJsonString();
    }
}

