/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.MemoryCache;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.runtime.ShutdownEvent;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import jakarta.enterprise.event.Observes;

public class DefaultTokenIntrospectionUserInfoCache
implements TokenIntrospectionCache,
UserInfoCache {
    private static final Uni<TokenIntrospection> NULL_INTROSPECTION_UNI = Uni.createFrom().nullItem();
    private static final Uni<UserInfo> NULL_USERINFO_UNI = Uni.createFrom().nullItem();
    final MemoryCache<CacheEntry> cache;

    public DefaultTokenIntrospectionUserInfoCache(OidcConfig oidcConfig, Vertx vertx) {
        this.cache = new MemoryCache(vertx, oidcConfig.tokenCache.cleanUpTimerInterval, oidcConfig.tokenCache.timeToLive, oidcConfig.tokenCache.maxSize);
    }

    @Override
    public Uni<Void> addIntrospection(String token, TokenIntrospection introspection, OidcTenantConfig oidcTenantConfig, OidcRequestContext<Void> requestContext) {
        CacheEntry entry = this.cache.get(token);
        if (entry != null) {
            entry.introspection = introspection;
        } else {
            this.cache.add(token, new CacheEntry(introspection));
        }
        return CodeAuthenticationMechanism.VOID_UNI;
    }

    @Override
    public Uni<TokenIntrospection> getIntrospection(String token, OidcTenantConfig oidcConfig, OidcRequestContext<TokenIntrospection> requestContext) {
        CacheEntry entry = this.cache.get(token);
        return entry == null ? NULL_INTROSPECTION_UNI : Uni.createFrom().item((Object)entry.introspection);
    }

    @Override
    public Uni<Void> addUserInfo(String token, UserInfo userInfo, OidcTenantConfig oidcTenantConfig, OidcRequestContext<Void> requestContext) {
        CacheEntry entry = this.cache.get(token);
        if (entry != null) {
            entry.userInfo = userInfo;
        } else {
            this.cache.add(token, new CacheEntry(userInfo));
        }
        return CodeAuthenticationMechanism.VOID_UNI;
    }

    @Override
    public Uni<UserInfo> getUserInfo(String token, OidcTenantConfig oidcConfig, OidcRequestContext<UserInfo> requestContext) {
        CacheEntry entry = this.cache.get(token);
        return entry == null ? NULL_USERINFO_UNI : Uni.createFrom().item((Object)entry.userInfo);
    }

    public void clearCache() {
        this.cache.clearCache();
    }

    public int getCacheSize() {
        return this.cache.getCacheSize();
    }

    void shutdown(@Observes ShutdownEvent event, Vertx vertx) {
        this.cache.stopTimer(vertx);
    }

    private static class CacheEntry {
        volatile TokenIntrospection introspection;
        volatile UserInfo userInfo;

        public CacheEntry(TokenIntrospection introspection) {
            this.introspection = introspection;
        }

        public CacheEntry(UserInfo userInfo) {
            this.userInfo = userInfo;
        }
    }
}

