/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.common.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ProxyUnwrapperBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.RestClientBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyJsonConfig;
import io.quarkus.resteasy.common.runtime.ResteasyInjectorFactoryRecorder;
import io.quarkus.resteasy.common.runtime.providers.ServerFormUrlEncodedProvider;
import io.quarkus.resteasy.common.spi.ResteasyConfigBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.MemorySize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.plugins.interceptors.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.spi.InjectorFactory;

public class ResteasyCommonProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ResteasyCommonProcessor.class.getName());
    private static final ProviderDiscoverer[] PROVIDER_DISCOVERERS = new ProviderDiscoverer[]{new ProviderDiscoverer(ResteasyDotNames.GET, false, true), new ProviderDiscoverer(ResteasyDotNames.HEAD, false, false), new ProviderDiscoverer(ResteasyDotNames.DELETE, true, false), new ProviderDiscoverer(ResteasyDotNames.OPTIONS, false, true), new ProviderDiscoverer(ResteasyDotNames.PATCH, true, false), new ProviderDiscoverer(ResteasyDotNames.POST, true, true), new ProviderDiscoverer(ResteasyDotNames.PUT, true, false)};
    private static final DotName QUARKUS_OBJECT_MAPPER_CONTEXT_RESOLVER = DotName.createSimple((String)"io.quarkus.resteasy.common.runtime.jackson.QuarkusObjectMapperContextResolver");
    private static final DotName OBJECT_MAPPER = DotName.createSimple((String)"com.fasterxml.jackson.databind.ObjectMapper");
    private static final DotName QUARKUS_JACKSON_SERIALIZER = DotName.createSimple((String)"io.quarkus.resteasy.common.runtime.jackson.QuarkusJacksonSerializer");
    private static final DotName QUARKUS_JSONB_CONTEXT_RESOLVER = DotName.createSimple((String)"io.quarkus.resteasy.common.runtime.jsonb.QuarkusJsonbContextResolver");
    private static final DotName JSONB = DotName.createSimple((String)"javax.json.bind.Jsonb");
    private static final DotName QUARKUS_JSONB_SERIALIZER = DotName.createSimple((String)"io.quarkus.resteasy.common.runtime.jsonb.QuarkusJsonbSerializer");
    private ResteasyCommonConfig resteasyCommonConfig;

    @BuildStep
    ResteasyConfigBuildItem resteasyConfig(ResteasyJsonConfig resteasyJsonConfig, Capabilities capabilities) {
        return new ResteasyConfigBuildItem(resteasyJsonConfig.jsonDefault && (capabilities.isPresent(Capability.REST_JACKSON) || capabilities.isPresent(Capability.REST_JSONB)));
    }

    @BuildStep
    void setupGzipProviders(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        if (this.resteasyCommonConfig.gzip.enabled) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AcceptEncodingGZIPFilter.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(GZIPDecodingInterceptor.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(GZIPEncodingInterceptor.class.getName()));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    ResteasyInjectionReadyBuildItem setupResteasyInjection(List<ProxyUnwrapperBuildItem> proxyUnwrappers, BeanContainerBuildItem beanContainerBuildItem, Capabilities capabilities, ResteasyInjectorFactoryRecorder recorder) {
        ArrayList<Function> unwrappers = new ArrayList<Function>();
        for (ProxyUnwrapperBuildItem i : proxyUnwrappers) {
            unwrappers.add(i.getUnwrapper());
        }
        RuntimeValue injectorFactory = recorder.setup(beanContainerBuildItem.getValue(), unwrappers);
        return new ResteasyInjectionReadyBuildItem((RuntimeValue<InjectorFactory>)injectorFactory);
    }

    @BuildStep
    JaxrsProvidersToRegisterBuildItem setupProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem indexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, List<ResteasyJaxrsProviderBuildItem> contributedProviderBuildItems, List<RestClientBuildItem> restClients, ResteasyConfigBuildItem resteasyConfig, Capabilities capabilities) throws Exception {
        String needsMutinyClasses;
        HashSet<String> contributedProviders = new HashSet<String>();
        for (ResteasyJaxrsProviderBuildItem contributedProviderBuildItem : contributedProviderBuildItems) {
            contributedProviders.add(contributedProviderBuildItem.getName());
        }
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(ResteasyDotNames.PROVIDER)) {
            if (i.target().kind() == AnnotationTarget.Kind.CLASS) {
                contributedProviders.add(i.target().asClass().name().toString());
            }
            this.checkProperConfigAccessInProvider(i);
            this.checkProperConstructorInProvider(i);
        }
        HashSet<String> availableProviders = new HashSet<String>(ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + Providers.class.getName())));
        availableProviders.add(ServerFormUrlEncodedProvider.class.getName());
        MediaTypeMap categorizedReaders = new MediaTypeMap();
        MediaTypeMap categorizedWriters = new MediaTypeMap();
        MediaTypeMap categorizedContextResolvers = new MediaTypeMap();
        HashSet<String> otherProviders = new HashSet<String>();
        ResteasyCommonProcessor.categorizeProviders(availableProviders, (MediaTypeMap<String>)categorizedReaders, (MediaTypeMap<String>)categorizedWriters, (MediaTypeMap<String>)categorizedContextResolvers, otherProviders);
        HashSet<String> providersToRegister = new HashSet<String>(otherProviders);
        if (!capabilities.isPresent(Capability.RESTEASY_JSON)) {
            boolean needJsonSupport;
            boolean bl = needJsonSupport = this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.CONSUMES) || this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.PRODUCES) || this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.RESTEASY_SSE_ELEMENT_TYPE);
            if (needJsonSupport) {
                LOGGER.warn((Object)"Quarkus detected the need of REST JSON support but you have not provided the necessary JSON extension for this. You can visit https://quarkus.io/guides/rest-json for more information on how to set one.");
            }
        }
        if (!capabilities.isPresent(Capability.RESTEASY_MUTINY) && (needsMutinyClasses = this.mutinySupportNeeded(indexBuildItem)) != null) {
            LOGGER.warn((Object)("Quarkus detected the need for Mutiny reactive programming support, however the quarkus-resteasy-mutiny extension was not present. Reactive REST endpoints in your application that return Uni or Multi will not function as you expect until you add this extension. Endpoints that need Mutiny are: " + needsMutinyClasses));
        }
        providersToRegister.add(StringTextStar.class.getName());
        providersToRegister.addAll(categorizedWriters.getPossible(MediaType.APPLICATION_JSON_TYPE));
        IndexView index = indexBuildItem.getIndex();
        IndexView beansIndex = beanArchiveIndexBuildItem.getIndex();
        boolean useBuiltinProviders = ResteasyCommonProcessor.collectDeclaredProviders(restClients, resteasyConfig, providersToRegister, (MediaTypeMap<String>)categorizedReaders, (MediaTypeMap<String>)categorizedWriters, (MediaTypeMap<String>)categorizedContextResolvers, index, beansIndex);
        if (useBuiltinProviders) {
            providersToRegister = new HashSet(contributedProviders);
            providersToRegister.addAll(availableProviders);
        } else {
            providersToRegister.addAll(contributedProviders);
        }
        if (providersToRegister.contains("org.jboss.resteasy.plugins.providers.jsonb.JsonBindingProvider")) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.jboss.resteasy.plugins.providers.jsonb.AbstractJsonBindingProvider"}));
        }
        return new JaxrsProvidersToRegisterBuildItem(providersToRegister, contributedProviders, useBuiltinProviders);
    }

    private String mutinySupportNeeded(CombinedIndexBuildItem indexBuildItem) {
        HashSet<DotName> mutinyTypes = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)"io.smallrye.mutiny.Uni"), DotName.createSimple((String)"io.smallrye.mutiny.Multi"), DotName.createSimple((String)"io.smallrye.mutiny.GroupedMulti")));
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (DotName annotation : ResteasyDotNames.JAXRS_METHOD_ANNOTATIONS) {
            for (AnnotationInstance instance : indexBuildItem.getIndex().getAnnotations(annotation)) {
                MethodInfo methodInfo = instance.target().asMethod();
                Type type = methodInfo.returnType();
                if (!mutinyTypes.contains(type.name())) continue;
                methods.add(methodInfo);
            }
        }
        if (methods.isEmpty()) {
            return null;
        }
        return methods.stream().map(new Function<MethodInfo, String>(){

            @Override
            public String apply(MethodInfo methodInfo) {
                return methodInfo.declaringClass().toString() + "{" + methodInfo.toString() + "}";
            }
        }).collect(Collectors.joining(", "));
    }

    @BuildStep
    void registerJsonContextResolvers(CombinedIndexBuildItem combinedIndexBuildItem, Capabilities capabilities, ResteasyJsonConfig resteasyJsonConfig, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProvider, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<UnremovableBeanBuildItem> unremovable) {
        if (capabilities.isPresent(Capability.REST_JACKSON)) {
            this.registerJsonContextResolver(OBJECT_MAPPER, QUARKUS_OBJECT_MAPPER_CONTEXT_RESOLVER, combinedIndexBuildItem, jaxrsProvider, additionalBean, unremovable);
            if (resteasyJsonConfig.jsonDefault) {
                jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QUARKUS_JACKSON_SERIALIZER.toString()));
            }
        }
        if (capabilities.isPresent(Capability.REST_JSONB)) {
            this.registerJsonContextResolver(JSONB, QUARKUS_JSONB_CONTEXT_RESOLVER, combinedIndexBuildItem, jaxrsProvider, additionalBean, unremovable);
            if (resteasyJsonConfig.jsonDefault) {
                jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QUARKUS_JSONB_SERIALIZER.toString()));
            }
        }
    }

    private void registerJsonContextResolver(DotName jsonImplementation, DotName jsonContextResolver, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProvider, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<UnremovableBeanBuildItem> unremovable) {
        IndexView index = combinedIndexBuildItem.getIndex();
        jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(jsonContextResolver.toString()));
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)jsonContextResolver.toString()));
        Set<String> userSuppliedProducers = this.getUserSuppliedJsonProducerBeans(index, jsonImplementation);
        if (!userSuppliedProducers.isEmpty()) {
            unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(userSuppliedProducers)));
        }
    }

    private Set<String> getUserSuppliedJsonProducerBeans(IndexView index, DotName jsonImplementation) {
        HashSet<String> result = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !jsonImplementation.equals((Object)annotation.target().asMethod().returnType().name())) continue;
            result.add(annotation.target().asMethod().declaringClass().name().toString());
        }
        return result;
    }

    private void checkProperConfigAccessInProvider(AnnotationInstance instance) {
        List configPropertyInstances = (List)instance.target().asClass().annotations().get(ResteasyDotNames.CONFIG_PROPERTY);
        if (configPropertyInstances == null) {
            return;
        }
        for (AnnotationInstance configPropertyInstance : configPropertyInstances) {
            FieldInfo field;
            Type fieldType;
            if (configPropertyInstance.target().kind() != AnnotationTarget.Kind.FIELD || ResteasyDotNames.CDI_INSTANCE.equals((Object)(fieldType = (field = configPropertyInstance.target().asField()).type()).name())) continue;
            LOGGER.warn((Object)("Directly injecting a @" + ResteasyDotNames.CONFIG_PROPERTY.withoutPackagePrefix() + " into a JAX-RS provider may lead to unexpected results. To ensure proper results, please change the type of the field to " + ParameterizedType.create((DotName)ResteasyDotNames.CDI_INSTANCE, (Type[])new Type[]{fieldType}, null) + ". Offending field is '" + field.name() + "' of class '" + field.declaringClass() + "'"));
        }
    }

    private void checkProperConstructorInProvider(AnnotationInstance i) {
        ClassInfo targetClass = i.target().asClass();
        if (!targetClass.hasNoArgsConstructor() || targetClass.methods().stream().filter(m -> m.name().equals("<init>")).count() > 1L) {
            LOGGER.warn((Object)("Classes annotated with @Provider should have a single, no-argument constructor, otherwise dependency injection won't work properly. Offending class is " + targetClass));
        }
    }

    private boolean restJsonSupportNeeded(CombinedIndexBuildItem indexBuildItem, DotName mediaTypeAnnotation) {
        for (AnnotationInstance annotationInstance : indexBuildItem.getIndex().getAnnotations(mediaTypeAnnotation)) {
            AnnotationValue annotationValue = annotationInstance.value();
            if (annotationValue == null) continue;
            List<Object> mediaTypes = Collections.emptyList();
            if (annotationValue.kind() == AnnotationValue.Kind.ARRAY) {
                mediaTypes = Arrays.asList(annotationValue.asStringArray());
            } else if (annotationValue.kind() == AnnotationValue.Kind.STRING) {
                mediaTypes = Collections.singletonList(annotationValue.asString());
            }
            return mediaTypes.contains("application/json") || mediaTypes.contains("application/json-patch+json");
        }
        return false;
    }

    public static void categorizeProviders(Set<String> availableProviders, MediaTypeMap<String> categorizedReaders, MediaTypeMap<String> categorizedWriters, MediaTypeMap<String> categorizedContextResolvers, Set<String> otherProviders) {
        for (String availableProvider : availableProviders) {
            try {
                Produces produces;
                Class<?> providerClass = Class.forName(availableProvider, false, Thread.currentThread().getContextClassLoader());
                if (MessageBodyReader.class.isAssignableFrom(providerClass) || MessageBodyWriter.class.isAssignableFrom(providerClass)) {
                    if (MessageBodyReader.class.isAssignableFrom(providerClass)) {
                        Consumes consumes = providerClass.getAnnotation(Consumes.class);
                        if (consumes != null) {
                            for (String consumesMediaType : consumes.value()) {
                                categorizedReaders.add(MediaType.valueOf((String)consumesMediaType), (Object)providerClass.getName());
                            }
                        } else {
                            categorizedReaders.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                        }
                    }
                    if (!MessageBodyWriter.class.isAssignableFrom(providerClass)) continue;
                    produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        for (String producesMediaType : produces.value()) {
                            categorizedWriters.add(MediaType.valueOf((String)producesMediaType), (Object)providerClass.getName());
                        }
                        continue;
                    }
                    categorizedWriters.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                    continue;
                }
                if (ContextResolver.class.isAssignableFrom(providerClass)) {
                    produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        for (String producesMediaType : produces.value()) {
                            categorizedContextResolvers.add(MediaType.valueOf((String)producesMediaType), (Object)providerClass.getName());
                        }
                        continue;
                    }
                    categorizedContextResolvers.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                    continue;
                }
                otherProviders.add(providerClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private static boolean collectDeclaredProviders(List<RestClientBuildItem> restClients, ResteasyConfigBuildItem resteasyConfig, Set<String> providersToRegister, MediaTypeMap<String> categorizedReaders, MediaTypeMap<String> categorizedWriters, MediaTypeMap<String> categorizedContextResolvers, IndexView ... indexes) {
        Set restClientNames = restClients.stream().map(RestClientBuildItem::getInterfaceName).collect(Collectors.toSet());
        for (IndexView index : indexes) {
            for (ProviderDiscoverer providerDiscoverer : PROVIDER_DISCOVERERS) {
                Collection getMethods = index.getAnnotations(providerDiscoverer.getMethodAnnotation());
                for (AnnotationInstance getMethod : getMethods) {
                    MethodInfo methodTarget = getMethod.target().asMethod();
                    boolean isRestClient = restClientNames.contains(methodTarget.declaringClass().name().toString());
                    if (isRestClient) {
                        if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedWriters, methodTarget, ResteasyDotNames.CONSUMES, providerDiscoverer.noConsumesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                            return true;
                        }
                        if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedReaders, methodTarget, ResteasyDotNames.PRODUCES, providerDiscoverer.noProducesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                            return true;
                        }
                    } else {
                        if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedReaders, methodTarget, ResteasyDotNames.CONSUMES, providerDiscoverer.noConsumesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                            return true;
                        }
                        if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedWriters, methodTarget, ResteasyDotNames.PRODUCES, providerDiscoverer.noProducesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                            return true;
                        }
                    }
                    if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedContextResolvers, methodTarget, ResteasyDotNames.CONSUMES, providerDiscoverer.noConsumesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                        return true;
                    }
                    if (!ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedContextResolvers, methodTarget, ResteasyDotNames.PRODUCES, providerDiscoverer.noProducesDefaultsToAll(), resteasyConfig.isJsonDefault())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean collectDeclaredProvidersForMethodAndMediaTypeAnnotation(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, MethodInfo methodTarget, DotName mediaTypeAnnotation, boolean includeDefaults, boolean jsonDefault) {
        AnnotationInstance mediaTypeMethodAnnotationInstance = methodTarget.annotation(mediaTypeAnnotation);
        if (mediaTypeMethodAnnotationInstance == null) {
            AnnotationInstance mediaTypeClassAnnotationInstance = methodTarget.declaringClass().classAnnotation(mediaTypeAnnotation);
            if (mediaTypeClassAnnotationInstance != null) {
                return ResteasyCommonProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, mediaTypeClassAnnotationInstance.value().asStringArray(), methodTarget);
            }
            if (!includeDefaults) {
                return false;
            }
            if (jsonDefault) {
                ResteasyCommonProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, new String[]{"application/json"}, methodTarget);
                return false;
            }
            return true;
        }
        return ResteasyCommonProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, mediaTypeMethodAnnotationInstance.value().asStringArray(), methodTarget);
    }

    private static boolean collectDeclaredProvidersForMediaTypeAnnotationInstance(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, String[] mediaTypes, MethodInfo targetMethod) {
        for (String media : mediaTypes) {
            MediaType mediaType = MediaType.valueOf((String)media);
            if (MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
                return true;
            }
            providersToRegister.addAll(categorizedProviders.getPossible(mediaType));
            providersToRegister.addAll(ResteasyCommonProcessor.collectInferredProviders(mediaType, categorizedProviders, targetMethod));
        }
        return false;
    }

    private static Collection<String> collectInferredProviders(MediaType mediaType, MediaTypeMap<String> categorizedProviders, MethodInfo targetMethod) {
        if (ResteasyCommonProcessor.matches(MediaType.SERVER_SENT_EVENTS_TYPE, mediaType)) {
            HashSet<String> additionalProvidersToRegister = new HashSet<String>();
            AnnotationInstance sseElementTypeAnnInst = targetMethod.annotation(ResteasyDotNames.RESTEASY_SSE_ELEMENT_TYPE);
            String elementType = null;
            if (sseElementTypeAnnInst != null) {
                elementType = sseElementTypeAnnInst.value().asString();
            } else if (mediaType.getParameters() != null && mediaType.getParameters().containsKey("element-type")) {
                elementType = (String)mediaType.getParameters().get("element-type");
            }
            if (elementType != null) {
                additionalProvidersToRegister.addAll(categorizedProviders.getPossible(MediaType.valueOf((String)elementType)));
            } else {
                additionalProvidersToRegister.addAll(categorizedProviders.getPossible(MediaType.TEXT_PLAIN_TYPE));
            }
            return additionalProvidersToRegister;
        }
        return Collections.emptySet();
    }

    private static boolean matches(MediaType m1, MediaType m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.getType() == null || m1.getSubtype() == null) {
            return false;
        }
        return m1.getType().equalsIgnoreCase(m2.getType()) && m1.getSubtype().equalsIgnoreCase(m2.getSubtype());
    }

    private static enum NoMediaTypesDefault {
        ALL,
        JSON;

    }

    private static class ProviderDiscoverer {
        private final DotName methodAnnotation;
        private final boolean noConsumesDefaultsToAll;
        private final boolean noProducesDefaultsToAll;

        private ProviderDiscoverer(DotName methodAnnotation, boolean noConsumesDefaultsToAll, boolean noProducesDefaultsToAll) {
            this.methodAnnotation = methodAnnotation;
            this.noConsumesDefaultsToAll = noConsumesDefaultsToAll;
            this.noProducesDefaultsToAll = noProducesDefaultsToAll;
        }

        public DotName getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public boolean noConsumesDefaultsToAll() {
            return this.noConsumesDefaultsToAll;
        }

        public boolean noProducesDefaultsToAll() {
            return this.noProducesDefaultsToAll;
        }
    }

    @ConfigGroup
    public static final class ResteasyCommonConfigGzip {
        @ConfigItem
        public boolean enabled;
        @ConfigItem(defaultValue="10M")
        public MemorySize maxInput;
    }

    @ConfigRoot(name="resteasy")
    public static final class ResteasyCommonConfig {
        public ResteasyCommonConfigGzip gzip;
    }
}

