/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.BeanLookupSupplier;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.common.runtime.DefaultInvoker;
import io.quarkus.scheduler.common.runtime.MutableScheduledMethod;
import io.quarkus.scheduler.common.runtime.SchedulerContext;
import io.quarkus.scheduler.common.runtime.util.SchedulerUtils;
import io.quarkus.scheduler.deployment.KotlinUtil;
import io.quarkus.scheduler.deployment.ScheduledBusinessMethodItem;
import io.quarkus.scheduler.deployment.SchedulerDotNames;
import io.quarkus.scheduler.runtime.SchedulerConfig;
import io.quarkus.scheduler.runtime.SchedulerRecorder;
import io.quarkus.scheduler.runtime.SimpleScheduler;
import io.quarkus.scheduler.runtime.devconsole.SchedulerDevConsoleRecorder;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SchedulerProcessor {
    private static final Logger LOGGER = Logger.getLogger(SchedulerProcessor.class);
    static final Type SCHEDULED_EXECUTION_TYPE = Type.create((DotName)DotName.createSimple((String)ScheduledExecution.class.getName()), (Type.Kind)Type.Kind.CLASS);
    static final String INVOKER_SUFFIX = "_ScheduledInvoker";
    static final String NESTED_SEPARATOR = "$_";

    @BuildStep
    void beans(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isMissing("io.quarkus.quartz")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SimpleScheduler.class, Scheduled.ApplicationNotRunning.class}));
        }
    }

    @BuildStep
    AutoAddScopeBuildItem autoAddScope() {
        return AutoAddScopeBuildItem.builder().anyMethodMatches(m -> !Modifier.isStatic(m.flags()) && (m.hasAnnotation(SchedulerDotNames.SCHEDULED_NAME) || m.hasAnnotation(SchedulerDotNames.SCHEDULES_NAME))).defaultScope(BuiltinScope.SINGLETON).reason("Found non-static scheduled business methods").build();
    }

    @BuildStep
    void collectScheduledMethods(BeanArchiveIndexBuildItem beanArchives, BeanDiscoveryFinishedBuildItem beanDiscovery, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods) {
        ArrayList<AnnotationInstance> schedules = new ArrayList<AnnotationInstance>(beanArchives.getIndex().getAnnotations(SchedulerDotNames.SCHEDULED_NAME));
        for (AnnotationInstance annotationInstance : beanArchives.getIndex().getAnnotations(SchedulerDotNames.SCHEDULES_NAME)) {
            for (AnnotationInstance scheduledInstance : annotationInstance.value().asNestedArray()) {
                schedules.add(AnnotationInstance.create((DotName)scheduledInstance.name(), (AnnotationTarget)annotationInstance.target(), (List)scheduledInstance.values()));
            }
        }
        for (AnnotationInstance annotationInstance : schedules) {
            MethodInfo method;
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD || !Modifier.isStatic((method = annotationInstance.target().asMethod()).flags()) || KotlinUtil.isSuspendMethod(method)) continue;
            scheduledBusinessMethods.produce((BuildItem)new ScheduledBusinessMethodItem(null, method, schedules, transformedAnnotations.hasAnnotation((AnnotationTarget)method, SchedulerDotNames.NON_BLOCKING)));
            LOGGER.debugf("Found scheduled static method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
        }
        for (BeanInfo bean : beanDiscovery.beanStream().classBeans()) {
            this.collectScheduledMethods(beanArchives.getIndex(), transformedAnnotations, bean, ((AnnotationTarget)bean.getTarget().get()).asClass(), scheduledBusinessMethods);
        }
    }

    private void collectScheduledMethods(IndexView index, TransformedAnnotationsBuildItem transformedAnnotations, BeanInfo bean, ClassInfo beanClass, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods) {
        for (MethodInfo method : beanClass.methods()) {
            if (Modifier.isStatic(method.flags())) continue;
            List<AnnotationInstance> schedules = null;
            AnnotationInstance scheduledAnnotation = transformedAnnotations.getAnnotation((AnnotationTarget)method, SchedulerDotNames.SCHEDULED_NAME);
            if (scheduledAnnotation != null) {
                schedules = List.of(scheduledAnnotation);
            } else {
                AnnotationInstance schedulesAnnotation = transformedAnnotations.getAnnotation((AnnotationTarget)method, SchedulerDotNames.SCHEDULES_NAME);
                if (schedulesAnnotation != null) {
                    schedules = new ArrayList<AnnotationInstance>();
                    for (AnnotationInstance scheduledInstance : schedulesAnnotation.value().asNestedArray()) {
                        schedules.add(AnnotationInstance.create((DotName)scheduledInstance.name(), (AnnotationTarget)schedulesAnnotation.target(), (List)scheduledInstance.values()));
                    }
                }
            }
            if (schedules == null) continue;
            scheduledBusinessMethods.produce((BuildItem)new ScheduledBusinessMethodItem(bean, method, schedules, transformedAnnotations.hasAnnotation((AnnotationTarget)method, SchedulerDotNames.NON_BLOCKING)));
            LOGGER.debugf("Found scheduled business method %s declared on %s", (Object)method, (Object)bean);
        }
    }

    @BuildStep
    void validateScheduledBusinessMethods(SchedulerConfig config, List<ScheduledBusinessMethodItem> scheduledMethods, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        HashMap<String, AnnotationInstance> encounteredIdentities = new HashMap<String, AnnotationInstance>();
        HashSet<String> methodDescriptions = new HashSet<String>();
        for (ScheduledBusinessMethodItem scheduledMethod : scheduledMethods) {
            int maxParamSize;
            if (!methodDescriptions.add(scheduledMethod.getMethodDescription())) {
                errors.add(new IllegalStateException("Multiple @Scheduled methods of the same name declared on the same class: " + scheduledMethod.getMethodDescription()));
                continue;
            }
            MethodInfo method = scheduledMethod.getMethod();
            if (Modifier.isAbstract(method.flags())) {
                errors.add(new IllegalStateException("@Scheduled method must not be abstract: " + scheduledMethod.getMethodDescription()));
                continue;
            }
            if (Modifier.isPrivate(method.flags())) {
                errors.add(new IllegalStateException("@Scheduled method must not be private: " + scheduledMethod.getMethodDescription()));
                continue;
            }
            boolean isSuspendMethod = KotlinUtil.isSuspendMethod(method);
            List params = method.parameterTypes();
            int n = maxParamSize = isSuspendMethod ? 2 : 1;
            if (params.size() > maxParamSize || params.size() == maxParamSize && !((Type)params.get(0)).equals((Object)SCHEDULED_EXECUTION_TYPE)) {
                errors.add(new IllegalStateException(String.format("Invalid scheduled business method parameters %s [method: %s, bean: %s]", params, method, scheduledMethod.getBean())));
            }
            if (!this.isValidReturnType(method)) {
                if (isSuspendMethod) {
                    errors.add(new IllegalStateException(String.format("Suspending scheduled business method must return Unit [method: %s, bean: %s]", method, scheduledMethod.getBean())));
                } else {
                    errors.add(new IllegalStateException(String.format("Scheduled business method must return void, CompletionStage<Void> or Uni<Void> [method: %s, bean: %s]", method, scheduledMethod.getBean())));
                }
            }
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)config.cronType));
            for (AnnotationInstance scheduled : scheduledMethod.getSchedules()) {
                Throwable error = this.validateScheduled(parser, scheduled, encounteredIdentities, validationPhase.getContext());
                if (error == null) continue;
                errors.add(error);
            }
        }
        if (!errors.isEmpty()) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(errors));
        }
    }

    private boolean isValidReturnType(MethodInfo method) {
        Type returnType = method.returnType();
        if (returnType.kind() == Type.Kind.VOID) {
            return true;
        }
        if (SchedulerDotNames.COMPLETION_STAGE.equals((Object)returnType.name()) && ((Type)returnType.asParameterizedType().arguments().get(0)).name().equals((Object)SchedulerDotNames.VOID)) {
            return true;
        }
        if (SchedulerDotNames.UNI.equals((Object)returnType.name()) && ((Type)returnType.asParameterizedType().arguments().get(0)).name().equals((Object)SchedulerDotNames.VOID)) {
            return true;
        }
        return KotlinUtil.isSuspendMethod(method) && SchedulerDotNames.VOID.equals((Object)KotlinUtil.determineReturnTypeOfSuspendMethod(method).name());
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> unremovableBeans() {
        return List.of(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SchedulerDotNames.SCHEDULED_NAME)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SchedulerDotNames.SCHEDULES_NAME)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public FeatureBuildItem build(SchedulerConfig config, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SchedulerRecorder recorder, List<ScheduledBusinessMethodItem> scheduledMethods, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, AnnotationProxyBuildItem annotationProxy) {
        ArrayList<MutableScheduledMethod> scheduledMetadata = new ArrayList<MutableScheduledMethod>();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, (Function)new Function<String, String>(){

            @Override
            public String apply(String name) {
                int idx = name.indexOf(SchedulerProcessor.INVOKER_SUFFIX);
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                if (name.contains(SchedulerProcessor.NESTED_SEPARATOR)) {
                    name = name.replace(SchedulerProcessor.NESTED_SEPARATOR, "$");
                }
                return name;
            }
        });
        for (ScheduledBusinessMethodItem scheduledMethod : scheduledMethods) {
            MutableScheduledMethod metadata = new MutableScheduledMethod();
            String invokerClass = this.generateInvoker(scheduledMethod, (ClassOutput)classOutput);
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{invokerClass}).constructors().methods().fields().build());
            metadata.setInvokerClassName(invokerClass);
            ArrayList<Scheduled> schedules = new ArrayList<Scheduled>();
            for (AnnotationInstance scheduled : scheduledMethod.getSchedules()) {
                schedules.add((Scheduled)annotationProxy.builder(scheduled, Scheduled.class).build((ClassOutput)classOutput));
            }
            metadata.setSchedules(schedules);
            metadata.setDeclaringClassName(scheduledMethod.getMethod().declaringClass().toString());
            metadata.setMethodName(scheduledMethod.getMethod().name());
            scheduledMetadata.add(metadata);
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(SchedulerContext.class).setRuntimeInit().supplier(recorder.createContext(config, scheduledMetadata)).done());
        return new FeatureBuildItem(Feature.SCHEDULER);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    public DevConsoleRouteBuildItem devConsole(BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> infos, SchedulerDevConsoleRecorder recorder, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        infos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("schedulerContext", (Supplier)new BeanLookupSupplier(SchedulerContext.class), this.getClass(), curateOutcomeBuildItem));
        infos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("scheduler", (Supplier)new BeanLookupSupplier(Scheduler.class), this.getClass(), curateOutcomeBuildItem));
        infos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("configLookup", recorder.getConfigLookup(), this.getClass(), curateOutcomeBuildItem));
        return new DevConsoleRouteBuildItem("schedules", "POST", recorder.invokeHandler());
    }

    @BuildStep
    public void metrics(SchedulerConfig config, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (config.metricsEnabled && metricsCapability.isPresent()) {
            DotName micrometerTimed = DotName.createSimple((String)"io.micrometer.core.annotation.Timed");
            DotName mpTimed = DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.Timed");
            annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(((AnnotationsTransformer.Builder)((AnnotationsTransformer.Builder)AnnotationsTransformer.builder().appliesTo(AnnotationTarget.Kind.METHOD).whenContainsAny(List.of(SchedulerDotNames.SCHEDULED_NAME, SchedulerDotNames.SCHEDULES_NAME))).whenContainsNone(List.of(micrometerTimed, mpTimed, DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.SimplyTimed")))).transform(context -> {
                MethodInfo scheduledMethod = context.getTarget().asMethod();
                if (((MetricsCapabilityBuildItem)metricsCapability.get()).metricsSupported("micrometer")) {
                    ((Transformation)((Transformation)context.transform().add(micrometerTimed, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)"scheduled.methods")})).add(micrometerTimed, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)"scheduled.methods.running"), AnnotationValue.createBooleanValue((String)"longTask", (boolean)true)})).done();
                    LOGGER.debugf("Added Micrometer @Timed to a @Scheduled method %s#%s()", (Object)scheduledMethod.declaringClass().name(), (Object)scheduledMethod.name());
                } else if (((MetricsCapabilityBuildItem)metricsCapability.get()).metricsSupported("smallrye-metrics")) {
                    ((Transformation)context.transform().add(mpTimed, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"tags", (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"scheduled", (String)"scheduled=true")})})).done();
                    LOGGER.debugf("Added MP Metrics @Timed to a @Scheduled method %s#%s()", (Object)scheduledMethod.declaringClass().name(), (Object)scheduledMethod.name());
                }
            })));
        }
    }

    @BuildStep
    public void tracing(SchedulerConfig config, Capabilities capabilities, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (config.tracingEnabled && capabilities.isPresent("io.quarkus.opentelemetry.tracer")) {
            DotName withSpan = DotName.createSimple((String)"io.opentelemetry.instrumentation.annotations.WithSpan");
            DotName legacyWithSpan = DotName.createSimple((String)"io.opentelemetry.extension.annotations.WithSpan");
            annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(((AnnotationsTransformer.Builder)((AnnotationsTransformer.Builder)AnnotationsTransformer.builder().appliesTo(AnnotationTarget.Kind.METHOD).whenContainsAny(List.of(SchedulerDotNames.SCHEDULED_NAME, SchedulerDotNames.SCHEDULES_NAME))).whenContainsNone(List.of(withSpan, legacyWithSpan))).transform(context -> {
                MethodInfo scheduledMethod = context.getTarget().asMethod();
                ((Transformation)context.transform().add(withSpan, new AnnotationValue[0])).done();
                LOGGER.debugf("Added OpenTelemetry @WithSpan to a @Scheduled method %s#%s()", (Object)scheduledMethod.declaringClass().name(), (Object)scheduledMethod.name());
            })));
        }
    }

    private String generateInvoker(ScheduledBusinessMethodItem scheduledMethod, ClassOutput classOutput) {
        ResultHandle res;
        BeanInfo bean = scheduledMethod.getBean();
        MethodInfo method = scheduledMethod.getMethod();
        boolean isStatic = Modifier.isStatic(method.flags());
        ClassInfo implClazz = isStatic ? method.declaringClass() : bean.getImplClazz();
        Object baseName = implClazz.enclosingClass() != null ? DotNames.simpleName((DotName)implClazz.enclosingClass()) + NESTED_SEPARATOR + DotNames.simpleName((ClassInfo)implClazz) : DotNames.simpleName((DotName)implClazz.name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameterTypes()) {
            sigBuilder.append(i.name().toString());
        }
        String generatedName = DotNames.internalPackageNameWithTrailingSlash((DotName)implClazz.name()) + (String)baseName + "_ScheduledInvoker_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        boolean isSuspendMethod = KotlinUtil.isSuspendMethod(method);
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(isSuspendMethod ? SchedulerDotNames.ABSTRACT_COROUTINE_INVOKER.toString() : DefaultInvoker.class.getName()).build();
        MethodCreator invoke = isSuspendMethod ? invokerCreator.getMethodCreator("invokeBean", Object.class.getName(), new String[]{ScheduledExecution.class.getName(), SchedulerDotNames.CONTINUATION.toString()}) : invokerCreator.getMethodCreator("invokeBean", CompletionStage.class, new Class[]{ScheduledExecution.class});
        TryBlock tryBlock = invoke.tryBlock();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        if (isSuspendMethod) {
            catchBlock.throwException(catchBlock.getCaughtException());
        } else {
            catchBlock.returnValue(catchBlock.invokeStaticMethod(MethodDescriptor.ofMethod(CompletableFuture.class, (String)"failedStage", CompletionStage.class, (Class[])new Class[]{Throwable.class}), new ResultHandle[]{catchBlock.getCaughtException()}));
        }
        String returnTypeStr = DescriptorUtils.typeToString((Type)method.returnType());
        if (isStatic) {
            res = method.parameterTypes().isEmpty() ? tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((String)implClazz.name().toString(), (String)method.name(), (String)returnTypeStr, (String[])new String[0]), new ResultHandle[0]) : tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((Object)implClazz.name().toString(), (String)method.name(), (Object)returnTypeStr, (Object[])new Object[]{ScheduledExecution.class}), new ResultHandle[]{tryBlock.getMethodParam(0)});
        } else {
            ResultHandle containerHandle = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle beanHandle = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), containerHandle, new ResultHandle[]{tryBlock.load(bean.getIdentifier())});
            ResultHandle instanceHandle = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class}), containerHandle, new ResultHandle[]{beanHandle});
            ResultHandle beanInstanceHandle = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
            res = isSuspendMethod ? (method.parametersCount() == 1 ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((String)implClazz.name().toString(), (String)method.name(), (String)Object.class.getName(), (String[])new String[]{SchedulerDotNames.CONTINUATION.toString()}), beanInstanceHandle, new ResultHandle[]{tryBlock.getMethodParam(1)}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((String)implClazz.name().toString(), (String)method.name(), (String)Object.class.getName(), (String[])new String[]{ScheduledExecution.class.getName(), SchedulerDotNames.CONTINUATION.toString()}), beanInstanceHandle, new ResultHandle[]{tryBlock.getMethodParam(0), tryBlock.getMethodParam(1)})) : (method.parameterTypes().isEmpty() ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((String)implClazz.name().toString(), (String)method.name(), (String)returnTypeStr, (String[])new String[0]), beanInstanceHandle, new ResultHandle[0]) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)implClazz.name().toString(), (String)method.name(), (Object)returnTypeStr, (Object[])new Object[]{ScheduledExecution.class}), beanInstanceHandle, new ResultHandle[]{tryBlock.getMethodParam(0)}));
            if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
                tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
            }
        }
        if (res == null) {
            res = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(CompletableFuture.class, (String)"completedStage", CompletionStage.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{tryBlock.loadNull()});
        } else if (method.returnType().name().equals((Object)SchedulerDotNames.UNI)) {
            res = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)SchedulerDotNames.UNI.toString(), (String)"subscribeAsCompletionStage", CompletableFuture.class, (Object[])new Object[0]), res, new ResultHandle[0]);
        }
        tryBlock.returnValue(res);
        if (scheduledMethod.isNonBlocking()) {
            MethodCreator isBlocking = invokerCreator.getMethodCreator("isBlocking", Boolean.TYPE, new Class[0]);
            isBlocking.returnValue(isBlocking.load(false));
        }
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private Throwable validateScheduled(CronParser parser, AnnotationInstance schedule, Map<String, AnnotationInstance> encounteredIdentities, BeanDeploymentValidator.ValidationContext validationContext) {
        DotName skipPredicate;
        AnnotationValue skipExecutionIfValue;
        AnnotationValue identityValue;
        MethodInfo method = schedule.target().asMethod();
        AnnotationValue cronValue = schedule.value("cron");
        AnnotationValue everyValue = schedule.value("every");
        if (cronValue != null && !cronValue.asString().trim().isEmpty()) {
            String timeZone;
            AnnotationValue timeZoneValue;
            String cron = cronValue.asString().trim();
            if (!SchedulerUtils.isConfigValue((String)cron)) {
                try {
                    parser.parse(cron).validate();
                }
                catch (IllegalArgumentException e) {
                    return new IllegalStateException("Invalid cron() expression on: " + schedule, e);
                }
                if (everyValue != null && !everyValue.asString().trim().isEmpty()) {
                    LOGGER.warnf("%s declared on %s#%s() defines both cron() and every() - the cron expression takes precedence", (Object)schedule, (Object)method.declaringClass().name(), (Object)method.name());
                }
            }
            if ((timeZoneValue = schedule.value("timeZone")) != null && !SchedulerUtils.isConfigValue((String)(timeZone = timeZoneValue.asString())) && !timeZone.equals("<<default timezone>>")) {
                try {
                    ZoneId.of(timeZone);
                }
                catch (Exception e) {
                    return new IllegalStateException("Invalid timeZone() on " + schedule, e);
                }
            }
        } else if (everyValue != null && !everyValue.asString().trim().isEmpty()) {
            Object every = everyValue.asString().trim();
            if (!SchedulerUtils.isConfigValue((String)every)) {
                if (Character.isDigit(((String)every).charAt(0))) {
                    every = "PT" + (String)every;
                }
                try {
                    Duration.parse((CharSequence)every);
                }
                catch (Exception e) {
                    return new IllegalStateException("Invalid every() expression on: " + schedule, e);
                }
            }
        } else {
            return new IllegalStateException("@Scheduled must declare either cron() or every(): " + schedule);
        }
        AnnotationValue delay = schedule.value("delay");
        AnnotationValue delayedValue = schedule.value("delayed");
        if (delay == null || delay.asLong() <= 0L) {
            Object delayed;
            if (delayedValue != null && !delayedValue.asString().trim().isEmpty() && !SchedulerUtils.isConfigValue((String)(delayed = delayedValue.asString().trim()))) {
                if (Character.isDigit(((String)delayed).charAt(0))) {
                    delayed = "PT" + (String)delayed;
                }
                try {
                    Duration.parse((CharSequence)delayed);
                }
                catch (Exception e) {
                    return new IllegalStateException("Invalid delayed() expression on: " + schedule, e);
                }
            }
        } else if (delayedValue != null && !delayedValue.asString().trim().isEmpty()) {
            LOGGER.warnf("%s declared on %s#%s() defines both delay() and delayed() - the delayed() value is ignored", (Object)schedule, (Object)method.declaringClass().name(), (Object)method.name());
        }
        if ((identityValue = schedule.value("identity")) != null) {
            String identity = SchedulerUtils.lookUpPropertyValue((String)identityValue.asString());
            AnnotationInstance previousInstanceWithSameIdentity = encounteredIdentities.get(identity);
            if (previousInstanceWithSameIdentity != null) {
                String message = String.format("The identity: \"%s\" on: %s is not unique and it has already bean used by : %s", identity, schedule, previousInstanceWithSameIdentity);
                return new IllegalStateException(message);
            }
            encounteredIdentities.put(identity, schedule);
        }
        if ((skipExecutionIfValue = schedule.value("skipExecutionIf")) != null && !SchedulerDotNames.SKIP_NEVER_NAME.equals((Object)(skipPredicate = skipExecutionIfValue.asClass().name())) && validationContext.beans().withBeanType(skipPredicate).collect().size() != 1) {
            String message = String.format("There must be exactly one bean that matches the skip predicate: \"%s\" on: %s", skipPredicate, schedule);
            return new IllegalStateException(message);
        }
        return null;
    }

    @BuildStep
    UnremovableBeanBuildItem unremoveableSkipPredicates() {
        return new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanTypeExclusion(SchedulerDotNames.SKIP_PREDICATE));
    }

    @BuildStep
    void produceCoroutineScope(BuildProducer<AdditionalBeanBuildItem> buildItemBuildProducer) {
        if (!QuarkusClassLoader.isClassPresentAtRuntime((String)"kotlinx.coroutines.CoroutineScope")) {
            return;
        }
        buildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass("io.quarkus.scheduler.kotlin.runtime.ApplicationCoroutineScope").setUnremovable().build());
    }
}

