/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor;

import io.quarkus.security.runtime.interceptor.SecurityConstrainer;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.interceptor.InvocationContext;

@Singleton
public class SecurityHandler {
    private static final String HANDLER_NAME = SecurityHandler.class.getName();
    private static final String EXECUTED = "executed";
    @Inject
    SecurityConstrainer constrainer;

    public Object handle(InvocationContext ic) throws Exception {
        if (this.alreadyHandled(ic)) {
            return ic.proceed();
        }
        Class<?> returnType = ic.getMethod().getReturnType();
        if (Uni.class.isAssignableFrom(returnType)) {
            return this.constrainer.nonBlockingCheck(ic.getMethod(), ic.getParameters()).onItem().transformToUni((Function)new UniContinuation(ic));
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.constrainer.nonBlockingCheck(ic.getMethod(), ic.getParameters()).onItem().transformToUni(s -> {
                try {
                    return Uni.createFrom().completionStage((CompletionStage)ic.proceed());
                }
                catch (Exception e) {
                    return Uni.createFrom().failure((Throwable)e);
                }
            }).subscribeAsCompletionStage();
        }
        if (Multi.class.isAssignableFrom(returnType)) {
            return this.constrainer.nonBlockingCheck(ic.getMethod(), ic.getParameters()).onItem().transformToMulti((Function)new MultiContinuation(ic));
        }
        this.constrainer.check(ic.getMethod(), ic.getParameters());
        return ic.proceed();
    }

    private boolean alreadyHandled(InvocationContext ic) {
        return ic.getContextData().put(HANDLER_NAME, EXECUTED) != null;
    }

    private static class MultiContinuation
    implements Function<Object, Multi<?>> {
        private final InvocationContext ic;

        public MultiContinuation(InvocationContext invocationContext) {
            this.ic = invocationContext;
        }

        @Override
        public Multi<?> apply(Object o) {
            try {
                return (Multi)this.ic.proceed();
            }
            catch (Exception e) {
                return Multi.createFrom().failure((Throwable)e);
            }
        }
    }

    private static class UniContinuation
    implements Function<Object, Uni<?>> {
        private final InvocationContext ic;

        UniContinuation(InvocationContext invocationContext) {
            this.ic = invocationContext;
        }

        @Override
        public Uni<?> apply(Object o) {
            try {
                return (Uni)this.ic.proceed();
            }
            catch (Exception e) {
                return Uni.createFrom().failure((Throwable)e);
            }
        }
    }
}

