/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.smallrye.openapi.runtime.OpenApiConstants;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@ApplicationScoped
public class OpenApiDocumentService {
    private byte[] jsonDocument;
    private byte[] yamlDocument;

    @PostConstruct
    void create() throws IOException {
        block25: {
            ClassLoader cl = OpenApiConstants.classLoader == null ? Thread.currentThread().getContextClassLoader() : OpenApiConstants.classLoader;
            try (InputStream is = cl.getResourceAsStream("META-INF/quarkus-generated-openapi-doc." + Format.JSON);){
                if (is != null) {
                    try (OpenApiStaticFile staticFile = new OpenApiStaticFile(is, Format.JSON);){
                        Config config = ConfigProvider.getConfig();
                        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
                        OpenApiDocument document = OpenApiDocument.INSTANCE;
                        document.reset();
                        document.config((OpenApiConfig)openApiConfig);
                        document.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
                        document.filter(OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)cl));
                        document.initialize();
                        this.jsonDocument = OpenApiSerializer.serialize((OpenAPI)document.get(), (Format)Format.JSON).getBytes(StandardCharsets.UTF_8);
                        this.yamlDocument = OpenApiSerializer.serialize((OpenAPI)document.get(), (Format)Format.YAML).getBytes(StandardCharsets.UTF_8);
                        document.reset();
                        document = null;
                        break block25;
                    }
                }
                throw new IOException("Could not find [META-INF/quarkus-generated-openapi-doc." + Format.JSON + "]");
            }
        }
    }

    public byte[] getJsonDocument() {
        return this.jsonDocument;
    }

    public byte[] getYamlDocument() {
        return this.yamlDocument;
    }

    public byte[] getDocument(Format format) {
        if (format.equals((Object)Format.JSON)) {
            return this.getJsonDocument();
        }
        return this.getYamlDocument();
    }
}

