/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.function.BiFunction;

public interface HttpSecurityPolicy {
    public Uni<CheckResult> checkPermission(RoutingContext var1, Uni<SecurityIdentity> var2, AuthorizationRequestContext var3);

    default public String name() {
        return null;
    }

    public static interface AuthorizationRequestContext {
        public Uni<CheckResult> runBlocking(RoutingContext var1, Uni<SecurityIdentity> var2, BiFunction<RoutingContext, SecurityIdentity, CheckResult> var3);
    }

    public static class CheckResult {
        public static CheckResult DENY = new CheckResult(false);
        public static CheckResult PERMIT = new CheckResult(true);
        private final boolean permitted;
        private final SecurityIdentity augmentedIdentity;

        public CheckResult(boolean permitted) {
            this.permitted = permitted;
            this.augmentedIdentity = null;
        }

        public CheckResult(boolean permitted, SecurityIdentity augmentedIdentity) {
            this.permitted = permitted;
            this.augmentedIdentity = augmentedIdentity;
        }

        public boolean isPermitted() {
            return this.permitted;
        }

        public SecurityIdentity getAugmentedIdentity() {
            return this.augmentedIdentity;
        }
    }
}

