/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.client.runtime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.nativeimage.hosted.Feature;

public class DisableLoggingFeature
implements Feature {
    private static final String[] CATEGORIES = new String[]{"io.undertow.websockets"};
    private final Map<String, Level> categoryMap = new HashMap<String, Level>(CATEGORIES.length);

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        for (String category : CATEGORIES) {
            Logger logger = Logger.getLogger(category);
            this.categoryMap.put(category, logger.getLevel());
            logger.setLevel(Level.WARNING);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        for (String category : CATEGORIES) {
            Level level = this.categoryMap.remove(category);
            if (level == null) continue;
            Logger logger = Logger.getLogger(category);
            logger.setLevel(level);
        }
    }

    public String getDescription() {
        return "Disables INFO logging during the analysis phase for the " + Arrays.toString(CATEGORIES) + " categories";
    }
}

