/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.RuntimeDelegate;

public class LinkImpl
extends Link {
    protected final URI uri;
    protected final Map<String, String> map;
    protected static final RuntimeDelegate.HeaderDelegate<Link> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(Link.class);

    public static Link valueOf(String value) {
        return (Link)delegate.fromString(value);
    }

    LinkImpl(URI uri, Map<String, String> map) {
        this.uri = uri;
        this.map = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(map));
    }

    public URI getUri() {
        return this.uri;
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri((URI)this.uri);
    }

    public String getRel() {
        return this.map.get("rel");
    }

    public List<String> getRels() {
        String rels = this.map.get("rel");
        return rels == null ? Collections.emptyList() : Arrays.asList(rels.split(" +"));
    }

    public String getTitle() {
        return this.map.get("title");
    }

    public String getType() {
        return this.map.get("type");
    }

    public Map<String, String> getParams() {
        return this.map;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LinkImpl) {
            LinkImpl otherLink = (LinkImpl)((Object)other);
            return this.uri.equals(otherLink.uri) && this.map.equals(otherLink.map);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 89 * hash + (this.map != null ? this.map.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return delegate.toString((Object)this);
    }
}

