/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.BeanParamInfo;
import org.jboss.resteasy.reactive.common.model.InjectableBean;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ListConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.LoadedParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.LocalDateParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.NoopParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.OptionalConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.PathSegmentParamConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.SetConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.SortedSetConverter;
import org.jboss.resteasy.reactive.server.core.reflection.ReflectionConstructorParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.reflection.ReflectionValueOfParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerMethodParameter;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.processor.EndpointInvokerFactory;
import org.jboss.resteasy.reactive.server.processor.ReflectionEndpointInvokerFactory;
import org.jboss.resteasy.reactive.server.processor.ServerIndexedParameter;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerFormUrlEncodedProvider;
import org.jboss.resteasy.reactive.server.providers.serialisers.jsonp.ServerJsonArrayHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.jsonp.ServerJsonObjectHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.jsonp.ServerJsonStructureHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.jsonp.ServerJsonValueHandler;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;

public class ServerEndpointIndexer
extends EndpointIndexer<ServerEndpointIndexer, ServerIndexedParameter, ServerResourceMethod> {
    protected final EndpointInvokerFactory endpointInvokerFactory;
    protected final List<MethodScanner> methodScanners;

    protected ServerEndpointIndexer(AbstractBuilder builder) {
        super((EndpointIndexer.Builder)builder);
        this.endpointInvokerFactory = builder.endpointInvokerFactory;
        this.methodScanners = new ArrayList<MethodScanner>(builder.methodScanners);
    }

    protected void addWriterForType(AdditionalWriters additionalWriters, Type paramType) {
        DotName dotName = paramType.name();
        if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_VALUE) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_NUMBER) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRING)) {
            additionalWriters.add(ServerJsonValueHandler.class, "application/json", JsonValue.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_ARRAY)) {
            additionalWriters.add(ServerJsonArrayHandler.class, "application/json", JsonArray.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_OBJECT)) {
            additionalWriters.add(ServerJsonObjectHandler.class, "application/json", JsonObject.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRUCTURE)) {
            additionalWriters.add(ServerJsonStructureHandler.class, "application/json", JsonStructure.class);
        }
    }

    protected void addReaderForType(AdditionalReaders additionalReaders, Type paramType) {
        DotName dotName = paramType.name();
        if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_NUMBER) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_VALUE) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRING)) {
            additionalReaders.add(ServerJsonValueHandler.class, "application/json", JsonValue.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_ARRAY)) {
            additionalReaders.add(ServerJsonArrayHandler.class, "application/json", JsonArray.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_OBJECT)) {
            additionalReaders.add(ServerJsonObjectHandler.class, "application/json", JsonObject.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRUCTURE)) {
            additionalReaders.add(ServerJsonStructureHandler.class, "application/json", JsonStructure.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.MULTI_VALUED_MAP)) {
            additionalReaders.add(ServerFormUrlEncodedProvider.class, "application/x-www-form-urlencoded", MultivaluedMap.class);
        }
    }

    protected ServerIndexedParameter createIndexedParam() {
        return new ServerIndexedParameter();
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, ServerIndexedParameter builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        for (MethodScanner i : this.methodScanners) {
            ParameterExtractor res = i.handleCustomParameter(paramType, anns, field, methodContext);
            if (res == null) continue;
            builder.setType(ParameterType.CUSTOM);
            builder.setCustomerParameterExtractor(res);
            return true;
        }
        return false;
    }

    protected ServerResourceMethod createResourceMethod(MethodInfo methodInfo, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        ServerResourceMethod serverResourceMethod = new ServerResourceMethod();
        ArrayList<HandlerChainCustomizer> methodCustomizers = new ArrayList<HandlerChainCustomizer>();
        for (MethodScanner i : this.methodScanners) {
            List<HandlerChainCustomizer> scanned = i.scan(methodInfo, actualEndpointClass, methodContext);
            if (scanned == null) continue;
            methodCustomizers.addAll(scanned);
        }
        serverResourceMethod.setHandlerChainCustomizers(methodCustomizers);
        return serverResourceMethod;
    }

    protected boolean handleBeanParam(ClassInfo actualEndpointInfo, Type paramType, MethodParameter[] methodParameters, int i) {
        ClassInfo beanParamClassInfo = this.index.getClassByName(paramType.name());
        InjectableBean injectableBean = this.scanInjectableBean(beanParamClassInfo, actualEndpointInfo, this.existingConverters, this.additionalReaders, this.injectableBeans, this.hasRuntimeConverters);
        return injectableBean.isFormParamRequired();
    }

    protected boolean doesMethodHaveBlockingSignature(MethodInfo info) {
        for (MethodScanner i : this.methodScanners) {
            if (!i.isMethodSignatureAsync(info)) continue;
            return false;
        }
        return true;
    }

    protected void handleAdditionalMethodProcessing(ServerResourceMethod method, ClassInfo currentClassInfo, MethodInfo info, AnnotationStore annotationStore) {
        HandlerChainCustomizer i;
        Supplier<EndpointInvoker> invokerSupplier = null;
        Iterator iterator = method.getHandlerChainCustomizers().iterator();
        while (iterator.hasNext() && (invokerSupplier = (i = (HandlerChainCustomizer)iterator.next()).alternateInvoker(method)) == null) {
        }
        if (invokerSupplier == null) {
            invokerSupplier = this.endpointInvokerFactory.create((ResourceMethod)method, currentClassInfo, info);
        }
        method.setInvoker(invokerSupplier);
        HashSet<String> methodAnnotationNames = new HashSet<String>();
        Collection instances = annotationStore.getAnnotations((AnnotationTarget)info);
        for (AnnotationInstance instance : instances) {
            methodAnnotationNames.add(instance.name().toString());
        }
        method.setMethodAnnotationNames(methodAnnotationNames);
        this.validateMethodPath(method, currentClassInfo, info);
    }

    private void validateMethodPath(ServerResourceMethod method, ClassInfo currentClassInfo, MethodInfo info) {
        try {
            new URITemplate(method.getPath(), false);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Path '" + method.getPath() + "' of method '" + currentClassInfo.name() + "#" + info.name() + "' is not a valid expression", e);
        }
    }

    protected InjectableBean scanInjectableBean(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Map<String, String> existingConverters, AdditionalReaders additionalReaders, Map<String, InjectableBean> injectableBeans, boolean hasRuntimeConverters) {
        ClassInfo superClass;
        String currentTypeName = currentClassInfo.name().toString();
        InjectableBean currentInjectableBean = injectableBeans.get(currentTypeName);
        if (currentInjectableBean != null) {
            return currentInjectableBean;
        }
        currentInjectableBean = new BeanParamInfo();
        injectableBeans.put(currentTypeName, currentInjectableBean);
        LinkedHashMap<FieldInfo, ServerIndexedParameter> fieldExtractors = new LinkedHashMap<FieldInfo, ServerIndexedParameter>();
        LinkedHashMap<FieldInfo, ServerIndexedParameter> beanParamFields = new LinkedHashMap<FieldInfo, ServerIndexedParameter>();
        for (FieldInfo field : currentClassInfo.fields()) {
            HashMap<DotName, AnnotationInstance> annotations = new HashMap<DotName, AnnotationInstance>();
            for (AnnotationInstance i : field.annotations()) {
                annotations.put(i.name(), i);
            }
            ServerIndexedParameter result = (ServerIndexedParameter)this.extractParameterInfo(currentClassInfo, actualEndpointInfo, existingConverters, additionalReaders, annotations, field.type(), field.toString(), true, hasRuntimeConverters, Collections.emptySet(), field.name(), EMPTY_STRING_ARRAY, new HashMap());
            if (result.getType() != null && result.getType() != ParameterType.BEAN) {
                fieldExtractors.put(field, result);
            }
            if (result.getConverter() != null) {
                this.handleConverter(currentTypeName, field);
            }
            if (result.getType() == ParameterType.BEAN) {
                beanParamFields.put(field, result);
                ClassInfo beanParamClassInfo = this.index.getClassByName(field.type().name());
                InjectableBean injectableBean = this.scanInjectableBean(beanParamClassInfo, actualEndpointInfo, existingConverters, additionalReaders, injectableBeans, hasRuntimeConverters);
                if (!injectableBean.isFormParamRequired()) continue;
                currentInjectableBean.setFormParamRequired(true);
                continue;
            }
            if (result.getType() != ParameterType.FORM) continue;
            currentInjectableBean.setFormParamRequired(true);
        }
        fieldExtractors.putAll(beanParamFields);
        DotName superClassName = currentClassInfo.superName();
        boolean superTypeIsInjectable = false;
        if (superClassName != null && !superClassName.equals((Object)ResteasyReactiveDotNames.OBJECT) && (superClass = this.index.getClassByName(superClassName)) != null) {
            InjectableBean superInjectableBean = this.scanInjectableBean(superClass, actualEndpointInfo, existingConverters, additionalReaders, injectableBeans, hasRuntimeConverters);
            superTypeIsInjectable = superInjectableBean.isInjectionRequired();
            if (superInjectableBean.isFormParamRequired()) {
                currentInjectableBean.setFormParamRequired(true);
            }
        }
        if (!fieldExtractors.isEmpty()) {
            this.handleFieldExtractors(currentTypeName, fieldExtractors, superTypeIsInjectable);
        }
        currentInjectableBean.setInjectionRequired(!fieldExtractors.isEmpty() || superTypeIsInjectable);
        return currentInjectableBean;
    }

    protected void handleFieldExtractors(String currentTypeName, Map<FieldInfo, ServerIndexedParameter> fieldExtractors, boolean superTypeIsInjectable) {
    }

    protected void handleConverter(String currentTypeName, FieldInfo field) {
    }

    protected MethodParameter createMethodParameter(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, boolean encoded, Type paramType, ServerIndexedParameter parameterResult, String name, String defaultValue, ParameterType type, String elementType, boolean single, String signature) {
        ParameterConverterSupplier converter = parameterResult.getConverter();
        EndpointIndexer.DeclaredTypes declaredTypes = this.getDeclaredTypes(paramType, currentClassInfo, actualEndpointInfo);
        return new ServerMethodParameter(name, elementType, declaredTypes.getDeclaredType(), declaredTypes.getDeclaredUnresolvedType(), type, single, signature, converter, defaultValue, parameterResult.isObtainedAsCollection(), parameterResult.isOptional(), encoded, parameterResult.getCustomerParameterExtractor());
    }

    protected void handleOtherParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType) {
        try {
            builder.setConverter(this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not create converter for " + elementType + " for " + builder.getErrorLocation() + " of type " + builder.getType(), throwable);
        }
    }

    protected void handleSortedSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType) {
        ParameterConverterSupplier converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters);
        builder.setConverter((ParameterConverterSupplier)new SortedSetConverter.SortedSetSupplier(converter));
    }

    protected void handleOptionalParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType) {
        ParameterConverterSupplier converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters);
        builder.setConverter((ParameterConverterSupplier)new OptionalConverter.OptionalSupplier(converter));
    }

    protected void handleSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType) {
        ParameterConverterSupplier converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters);
        builder.setConverter((ParameterConverterSupplier)new SetConverter.SetSupplier(converter));
    }

    protected void handleListParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, ServerIndexedParameter builder, String elementType) {
        ParameterConverterSupplier converter = this.extractConverter(elementType, this.index, existingConverters, errorLocation, hasRuntimeConverters);
        builder.setConverter((ParameterConverterSupplier)new ListConverter.ListSupplier(converter));
    }

    protected void handlePathSegmentParam(ServerIndexedParameter builder) {
        builder.setConverter((ParameterConverterSupplier)new PathSegmentParamConverter.Supplier());
    }

    protected void handleLocalDateParam(ServerIndexedParameter builder) {
        builder.setConverter((ParameterConverterSupplier)new LocalDateParamConverter.Supplier());
    }

    private ParameterConverterSupplier extractConverter(String elementType, IndexView indexView, Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters) {
        if (elementType.equals(String.class.getName())) {
            if (hasRuntimeConverters) {
                return new RuntimeResolvedConverter.Supplier().setDelegate((ParameterConverterSupplier)new NoopParameterConverter.Supplier());
            }
            return null;
        }
        if (existingConverters.containsKey(elementType)) {
            String className = existingConverters.get(elementType);
            LoadedParameterConverter delegate = className == null ? null : new LoadedParameterConverter().setClassName(className);
            if (hasRuntimeConverters) {
                return new RuntimeResolvedConverter.Supplier().setDelegate((ParameterConverterSupplier)delegate);
            }
            if (delegate == null) {
                throw new RuntimeException("Failed to find converter for " + elementType);
            }
            return delegate;
        }
        if (elementType.equals(PathSegment.class.getName())) {
            return new PathSegmentParamConverter.Supplier();
        }
        return this.extractConverterImpl(elementType, indexView, existingConverters, errorLocation, hasRuntimeConverters);
    }

    protected ParameterConverterSupplier extractConverterImpl(String elementType, IndexView indexView, Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters) {
        MethodInfo fromString = null;
        MethodInfo valueOf = null;
        MethodInfo stringCtor = null;
        String primitiveWrapperType = (String)primitiveTypes.get(elementType);
        String prefix = "";
        if (primitiveWrapperType != null) {
            return new ReflectionValueOfParameterConverterSupplier(primitiveWrapperType);
        }
        ClassInfo type = indexView.getClassByName(DotName.createSimple((String)elementType));
        if (type != null) {
            for (MethodInfo i : type.methods()) {
                boolean isNotPrivate;
                boolean isStatic = (i.flags() & 8) != 0;
                boolean bl = isNotPrivate = (i.flags() & 2) == 0;
                if (i.parameters().size() != 1 || !isNotPrivate || !((Type)i.parameters().get(0)).name().equals((Object)ResteasyReactiveDotNames.STRING)) continue;
                if (i.name().equals("<init>")) {
                    stringCtor = i;
                    continue;
                }
                if (i.name().equals("valueOf") && isStatic) {
                    valueOf = i;
                    continue;
                }
                if (!i.name().equals("fromString") || !isStatic) continue;
                fromString = i;
            }
            if (type.isEnum() && fromString != null) {
                valueOf = null;
            }
        }
        ReflectionConstructorParameterConverterSupplier delegate = null;
        if (stringCtor != null) {
            delegate = new ReflectionConstructorParameterConverterSupplier(stringCtor.declaringClass().name().toString());
        } else if (valueOf != null) {
            delegate = new ReflectionValueOfParameterConverterSupplier(valueOf.declaringClass().name().toString());
        } else if (fromString != null) {
            delegate = new ReflectionValueOfParameterConverterSupplier(fromString.declaringClass().name().toString(), "fromString");
        }
        if (hasRuntimeConverters) {
            return new RuntimeResolvedConverter.Supplier().setDelegate((ParameterConverterSupplier)delegate);
        }
        if (delegate == null) {
            throw new RuntimeException("Failed to find converter for " + elementType);
        }
        return delegate;
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
    }

    public static class AbstractBuilder<B extends EndpointIndexer.Builder<ServerEndpointIndexer, B, ServerResourceMethod>>
    extends EndpointIndexer.Builder<ServerEndpointIndexer, B, ServerResourceMethod> {
        private EndpointInvokerFactory endpointInvokerFactory = new ReflectionEndpointInvokerFactory();
        private List<MethodScanner> methodScanners = new ArrayList<MethodScanner>();

        public EndpointInvokerFactory getEndpointInvokerFactory() {
            return this.endpointInvokerFactory;
        }

        public B setEndpointInvokerFactory(EndpointInvokerFactory endpointInvokerFactory) {
            this.endpointInvokerFactory = endpointInvokerFactory;
            return (B)((Object)this);
        }

        public B addMethodScanner(MethodScanner methodScanner) {
            this.methodScanners.add(methodScanner);
            return (B)((Object)this);
        }

        public B addMethodScanners(Collection<MethodScanner> methodScanners) {
            this.methodScanners.addAll(methodScanners);
            return (B)((Object)this);
        }

        public ServerEndpointIndexer build() {
            return new ServerEndpointIndexer(this);
        }
    }
}

