/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.ResteasyReactiveClientProblem;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.server.core.AsyncExceptionMapperContextImpl;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveAsyncExceptionMapper;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveExceptionMapper;

public class RuntimeExceptionMapper {
    private static final Logger log = Logger.getLogger(RuntimeExceptionMapper.class);
    private static Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> mappers;
    private final List<Predicate<Throwable>> blockingProblemPredicates;
    private final List<Predicate<Throwable>> nonBlockingProblemPredicate;
    private final Set<Class<? extends Throwable>> unwrappedExceptions;

    public RuntimeExceptionMapper(ExceptionMapping mapping, ClassLoader classLoader) {
        try {
            mappers = new HashMap<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>>();
            for (Map.Entry<String, ResourceExceptionMapper<? extends Throwable>> entry : mapping.effectiveMappers().entrySet()) {
                mappers.put(Class.forName(entry.getKey(), false, classLoader), entry.getValue());
            }
            this.blockingProblemPredicates = new ArrayList<Predicate<Throwable>>(mapping.blockingProblemPredicates);
            this.nonBlockingProblemPredicate = new ArrayList<Predicate<Throwable>>(mapping.nonBlockingProblemPredicate);
            this.unwrappedExceptions = new HashSet<Class<? extends Throwable>>();
            for (String string : mapping.unwrappedExceptions) {
                this.unwrappedExceptions.add(Class.forName(string, false, classLoader));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load exception mapper", e);
        }
    }

    public void mapException(Throwable throwable, ResteasyReactiveRequestContext context) {
        Class<?> klass = throwable.getClass();
        boolean isWebApplicationException = throwable instanceof WebApplicationException && !(throwable instanceof ResteasyReactiveClientProblem);
        Response response = null;
        if (isWebApplicationException) {
            response = ((WebApplicationException)throwable).getResponse();
        }
        if (response != null && response.hasEntity()) {
            context.setResult(response);
            return;
        }
        Map.Entry<Throwable, ExceptionMapper<Throwable>> entry = this.getExceptionMapper(klass, context, throwable);
        if (entry != null) {
            ExceptionMapper<Throwable> exceptionMapper = entry.getValue();
            Throwable mappedException = entry.getKey();
            context.requireCDIRequestScope();
            if (exceptionMapper instanceof ResteasyReactiveAsyncExceptionMapper) {
                ((ResteasyReactiveAsyncExceptionMapper)exceptionMapper).asyncResponse(mappedException, new AsyncExceptionMapperContextImpl(context));
                this.logBlockingErrorIfRequired(mappedException, context);
                this.logNonBlockingErrorIfRequired(mappedException, context);
                return;
            }
            response = exceptionMapper instanceof ResteasyReactiveExceptionMapper ? ((ResteasyReactiveExceptionMapper)exceptionMapper).toResponse(mappedException, context) : exceptionMapper.toResponse(mappedException);
            context.setResult(response);
            this.logBlockingErrorIfRequired(mappedException, context);
            this.logNonBlockingErrorIfRequired(mappedException, context);
            return;
        }
        if (isWebApplicationException) {
            context.setResult(response);
            this.logBlockingErrorIfRequired(throwable, context);
            return;
        }
        if (throwable instanceof IOException) {
            log.debugf(throwable, "IOError processing HTTP request to %s failed, the client likely terminated the connection.", (Object)context.serverRequest().getRequestAbsoluteUri());
        } else if (context.handlesUnmappedException()) {
            log.error((Object)"Request failed ", throwable);
        }
        this.logBlockingErrorIfRequired(throwable, context);
        this.logNonBlockingErrorIfRequired(throwable, context);
        context.handleUnmappedException(throwable);
    }

    private void logBlockingErrorIfRequired(Throwable throwable, ResteasyReactiveRequestContext context) {
        if (this.isBlockingProblem(throwable)) {
            RuntimeResource runtimeResource = context.getTarget();
            if (runtimeResource == null) {
                log.error((Object)("A blocking operation occurred on the IO thread. This likely means you need to use the @" + Blocking.class.getName() + " annotation on the Resource method, class or " + Application.class.getName() + " class."));
            } else {
                log.error((Object)("A blocking operation occurred on the IO thread. This likely means you need to annotate " + runtimeResource.getResourceClass().getName() + "#" + runtimeResource.getJavaMethodName() + "(" + Arrays.stream(runtimeResource.getParameterTypes()).map(Objects::toString).collect(Collectors.joining(", ")) + ") with @" + Blocking.class.getName() + ". Alternatively you can annotate the class " + runtimeResource.getResourceClass().getName() + " to make every method on the class blocking, or annotate your sub class of the " + Application.class.getName() + " class to make the whole application blocking"));
            }
        }
    }

    private void logNonBlockingErrorIfRequired(Throwable throwable, ResteasyReactiveRequestContext context) {
        if (this.isNonBlockingProblem(throwable)) {
            RuntimeResource runtimeResource = context.getTarget();
            if (runtimeResource == null) {
                log.error((Object)("An operation that needed be run on a Vert.x EventLoop thread was run on a worker pool thread. This likely means you use the @" + NonBlocking.class.getName() + " annotation on the Resource method, class or " + Application.class.getName() + " class."));
            } else {
                log.error((Object)("An operation that needed be run on a Vert.x EventLoop thread was run on a worker pool thread. This likely means you need to annotate " + runtimeResource.getResourceClass().getName() + "#" + runtimeResource.getJavaMethodName() + "(" + Arrays.stream(runtimeResource.getParameterTypes()).map(Objects::toString).collect(Collectors.joining(", ")) + ") with @" + NonBlocking.class.getName() + ". Alternatively you can annotate the class " + runtimeResource.getResourceClass().getName() + " to make every method on the class run on a Vert.x EventLoop thread, or annotate your sub class of the " + Application.class.getName() + " class to affect the entire application"));
            }
        }
    }

    private boolean isBlockingProblem(Throwable throwable) {
        return this.isKnownProblem(throwable, this.blockingProblemPredicates);
    }

    private boolean isNonBlockingProblem(Throwable throwable) {
        return this.isKnownProblem(throwable, this.nonBlockingProblemPredicate);
    }

    private boolean isKnownProblem(Throwable throwable, List<Predicate<Throwable>> predicates) {
        for (Throwable e = throwable; e != null; e = e.getCause()) {
            for (Predicate<Throwable> predicate : predicates) {
                if (!predicate.test(e)) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends Throwable> void addExceptionMapper(Class<T> exceptionClass, ResourceExceptionMapper<T> mapper) {
        ResourceExceptionMapper<? extends Throwable> existing = mappers.get(exceptionClass);
        if (existing != null && existing.getPriority() < mapper.getPriority()) {
            return;
        }
        mappers.put(exceptionClass, mapper);
    }

    public <T extends Throwable> Map.Entry<Throwable, ExceptionMapper<? extends Throwable>> getExceptionMapper(Class<T> clazz, ResteasyReactiveRequestContext context, T throwable) {
        Map.Entry<Throwable, ExceptionMapper<? extends Throwable>> result;
        Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> classExceptionMappers = this.getClassExceptionMappers(context);
        if (classExceptionMappers != null && !classExceptionMappers.isEmpty() && (result = this.doGetExceptionMapper(clazz, classExceptionMappers, throwable)) != null) {
            return result;
        }
        return this.doGetExceptionMapper(clazz, mappers, throwable);
    }

    private Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> getClassExceptionMappers(ResteasyReactiveRequestContext context) {
        if (context == null) {
            return null;
        }
        return context.getTarget() != null ? context.getTarget().getClassExceptionMappers() : null;
    }

    private <T extends Throwable> Map.Entry<Throwable, ExceptionMapper<? extends Throwable>> doGetExceptionMapper(Class<T> clazz, Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> mappers, Throwable throwable) {
        Throwable cause;
        Class<T> klass = clazz;
        do {
            ResourceExceptionMapper<? extends Throwable> mapper;
            if ((mapper = mappers.get(klass)) == null) continue;
            return new AbstractMap.SimpleEntry<Throwable, Object>(throwable, mapper.getFactory().createInstance().getInstance());
        } while ((klass = klass.getSuperclass()) != null);
        if (throwable != null && this.unwrappedExceptions.contains(clazz) && (cause = throwable.getCause()) != null) {
            return this.doGetExceptionMapper(cause.getClass(), mappers, cause);
        }
        return null;
    }

    public static Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> getMappers() {
        return mappers;
    }
}

