/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.util.CommonSseUtil;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.handlers.PublisherResponseHandler;
import org.jboss.resteasy.reactive.server.jaxrs.OutboundSseEventImpl;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;

public class SseUtil
extends CommonSseUtil {
    private static final String NL = "\n";

    public static CompletionStage<?> send(ResteasyReactiveRequestContext context, OutboundSseEvent event, List<PublisherResponseHandler.StreamingResponseCustomizer> customizers) {
        String data;
        ServerHttpResponse response = context.serverResponse();
        if (response.closed()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            data = SseUtil.serialiseEvent(context, event);
        }
        catch (IOException e) {
            CompletableFuture ret = new CompletableFuture();
            ret.completeExceptionally(e);
            return ret;
        }
        SseUtil.setHeaders(context, response, customizers);
        return response.write(data.getBytes(StandardCharsets.UTF_8));
    }

    private static String serialiseEvent(ResteasyReactiveRequestContext context, OutboundSseEvent event) throws IOException {
        StringBuilder sb = new StringBuilder();
        MediaType eventMediaType = null;
        if (event instanceof OutboundSseEventImpl && ((OutboundSseEventImpl)event).isMediaTypeSet()) {
            eventMediaType = event.getMediaType();
            SseUtil.serialiseField(context, sb, "content-type", eventMediaType.toString(), false);
        }
        if (event.getComment() != null) {
            SseUtil.serialiseField(context, sb, "", event.getComment(), false);
        }
        if (event.getId() != null) {
            SseUtil.serialiseField(context, sb, "id", event.getId(), false);
        }
        if (event.getName() != null) {
            SseUtil.serialiseField(context, sb, "event", event.getName(), false);
        }
        if (event.getReconnectDelay() != -1L && event.getReconnectDelay() >= 0L) {
            SseUtil.serialiseField(context, sb, "retry", Long.toString(event.getReconnectDelay()), false);
        }
        if (event.getData() != null) {
            String data = SseUtil.serialiseDataToString(context, event, eventMediaType);
            SseUtil.serialiseField(context, sb, "data", data, true);
        }
        sb.append(NL);
        return sb.toString();
    }

    private static void serialiseField(ResteasyReactiveRequestContext context, StringBuilder sb, String field, String value, boolean multiLine) {
        sb.append(field).append(":");
        int n = value.indexOf(10);
        int r = value.indexOf(13);
        if (n == -1 && r == -1) {
            sb.append(value).append(NL);
        } else if (!multiLine) {
            sb.append(value, 0, Math.max(n, r)).append(NL);
        } else {
            char[] chars = value.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '\n') {
                    sb.append(NL).append(field).append(":");
                    if (i + 1 >= chars.length || chars[i + 1] != '\r') continue;
                    ++i;
                    continue;
                }
                if (c == '\r') {
                    sb.append(NL).append(field).append(":");
                    continue;
                }
                sb.append(c);
            }
            sb.append(NL);
        }
    }

    private static String serialiseDataToString(ResteasyReactiveRequestContext context, OutboundSseEvent event, MediaType eventMediaType) throws IOException {
        MediaType mediaType;
        ServerSerialisers serialisers = context.getDeployment().getSerialisers();
        Object entity = event.getData();
        Class entityClass = event.getType();
        Type entityType = event.getGenericType();
        MediaType mediaType2 = mediaType = eventMediaType != null ? eventMediaType : context.getTarget().getStreamElementType();
        if (mediaType == null) {
            mediaType = MediaType.TEXT_PLAIN_TYPE;
        }
        MessageBodyWriter<?>[] writers = serialisers.findWriters(null, entityClass, mediaType).toArray(ServerSerialisers.NO_WRITER);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean wrote = false;
        for (MessageBodyWriter<?> writer : writers) {
            if (!writer.isWriteable(entityClass, entityType, Serialisers.NO_ANNOTATION, mediaType)) continue;
            writer.writeTo(entity, entityClass, entityType, Serialisers.NO_ANNOTATION, mediaType, (MultivaluedMap)new QuarkusMultivaluedHashMap(), (OutputStream)baos);
            wrote = true;
            break;
        }
        if (!wrote) {
            throw new IllegalStateException("Could not find MessageBodyWriter for " + entityClass);
        }
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    public static void setHeaders(ResteasyReactiveRequestContext context, ServerHttpResponse response) {
        SseUtil.setHeaders(context, response, Collections.emptyList());
    }

    public static void setHeaders(ResteasyReactiveRequestContext context, ServerHttpResponse response, List<PublisherResponseHandler.StreamingResponseCustomizer> customizers) {
        if (!response.headWritten()) {
            response.setStatusCode(Response.Status.OK.getStatusCode());
            response.setResponseHeader((CharSequence)"Content-Type", "text/event-stream");
            if (context.getTarget().getStreamElementType() != null) {
                response.setResponseHeader(SSE_CONTENT_TYPE, context.getTarget().getStreamElementType().toString());
            }
            response.setChunked(true);
            for (int i = 0; i < customizers.size(); ++i) {
                customizers.get(i).customize(response);
            }
        }
    }
}

