/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;

public final class SingleContains<T>
extends io.reactivex.Single<Boolean> {
    final SingleSource<T> source;
    final Object value;
    final BiPredicate<Object, Object> comparer;

    public SingleContains(SingleSource<T> source, Object value, BiPredicate<Object, Object> comparer) {
        this.source = source;
        this.value = value;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> s) {
        this.source.subscribe(new Single(s));
    }

    final class Single
    implements SingleObserver<T> {
        private final SingleObserver<? super Boolean> s;

        Single(SingleObserver<? super Boolean> s) {
            this.s = s;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.s.onSubscribe(d);
        }

        @Override
        public void onSuccess(T v) {
            boolean b;
            try {
                b = SingleContains.this.comparer.test(v, SingleContains.this.value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.s.onError(ex);
                return;
            }
            this.s.onSuccess((Boolean)b);
        }

        @Override
        public void onError(Throwable e) {
            this.s.onError(e);
        }
    }
}

