/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.function;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.function.ExceptionRunnable;

@FunctionalInterface
public interface ExceptionSupplier<T, E extends Exception> {
    public T get() throws E;

    default public ExceptionRunnable<E> andThen(ExceptionConsumer<? super T, ? extends E> after) {
        Assert.checkNotNullParam((String)"after", after);
        return () -> after.accept((T)this.get());
    }

    default public <R> ExceptionSupplier<R, E> andThen(ExceptionFunction<? super T, ? extends R, ? extends E> after) {
        Assert.checkNotNullParam((String)"after", after);
        return () -> after.apply((T)this.get());
    }
}

