/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.annotations.Broadcast;
import io.smallrye.reactive.messaging.annotations.EmitterFactoryFor;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;

public class DefaultEmitterConfiguration
implements EmitterConfiguration {
    private String name;
    private EmitterFactoryFor emitterType;
    private OnOverflow.Strategy overflowBufferStrategy;
    private long overflowBufferSize;
    private boolean broadcast;
    private int numberOfSubscriberBeforeConnecting;

    public DefaultEmitterConfiguration() {
    }

    public DefaultEmitterConfiguration(String name, EmitterFactoryFor emitterType, OnOverflow onOverflow, Broadcast broadcast) {
        this.name = name;
        this.emitterType = emitterType;
        if (onOverflow != null) {
            this.overflowBufferStrategy = onOverflow.value();
            this.overflowBufferSize = onOverflow.bufferSize();
        } else {
            this.overflowBufferStrategy = null;
            this.overflowBufferSize = -1L;
        }
        if (broadcast != null) {
            this.broadcast = Boolean.TRUE;
            this.numberOfSubscriberBeforeConnecting = broadcast.value();
        } else {
            this.numberOfSubscriberBeforeConnecting = -1;
        }
    }

    public String name() {
        return this.name;
    }

    public EmitterFactoryFor emitterType() {
        return this.emitterType;
    }

    public OnOverflow.Strategy overflowBufferStrategy() {
        return this.overflowBufferStrategy;
    }

    public long overflowBufferSize() {
        return this.overflowBufferSize;
    }

    public boolean broadcast() {
        return this.broadcast;
    }

    public int numberOfSubscriberBeforeConnecting() {
        return this.numberOfSubscriberBeforeConnecting;
    }
}

