/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import com.google.common.base.Optional;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483148)
public class SizeAnnotationPlugin
implements ParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SizeAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterContext context) {
        Optional<Size> size = Validators.annotationFromParameter(context, Size.class);
        LOG.debug("searching for @size: {}", (Object)size.isPresent());
        if (size.isPresent()) {
            AllowableRangeValues values = RangeAnnotations.stringLengthRange((Size)size.get());
            LOG.debug("Adding allowable Values @Size: {} - {}", (Object)values.getMin(), (Object)values.getMax());
            context.parameterBuilder().allowableValues((AllowableValues)values);
        }
    }
}

