/*
 * Decompiled with CFR 0.152.
 */
package boopickle;

import java.nio.ByteBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000513Q\u0001C\u0005\u0002\u00021AQa\u0005\u0001\u0005\u0002QAQa\u0006\u0001\u0005\u0002aAQa\r\u0001\u0005\u0002QBQ\u0001\u0010\u0001\u0005\u0002uBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ\u0001\u0012\u0001\u0005\u0012\u0015CQ\u0001\u0013\u0001\u0005\u0012%\u0013qb\u0015;sS:<7i\u001c3fG\u001a\u000b7\u000f\u001e\u0006\u0002\u0015\u0005I!m\\8qS\u000e\\G.Z\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003%\t!\u0002Z3d_\u0012,g)Y:u)\rIB%\u000b\t\u00035\u0005r!aG\u0010\u0011\u0005qyQ\"A\u000f\u000b\u0005yY\u0011A\u0002\u001fs_>$h(\u0003\u0002!\u001f\u00051\u0001K]3eK\u001aL!AI\u0012\u0003\rM#(/\u001b8h\u0015\t\u0001s\u0002C\u0003&\u0005\u0001\u0007a%A\u0002mK:\u0004\"AD\u0014\n\u0005!z!aA%oi\")!F\u0001a\u0001W\u0005\u0019!-\u001e4\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013a\u00018j_*\t\u0001'\u0001\u0003kCZ\f\u0017B\u0001\u001a.\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u000bK:\u001cw\u000eZ3GCN$HcA\u001b9uA\u0011aBN\u0005\u0003o=\u0011A!\u00168ji\")\u0011h\u0001a\u00013\u0005\t1\u000fC\u0003<\u0007\u0001\u00071&\u0001\u0002cE\u0006yQM\\2pI\u00164\u0015m\u001d;BeJ\f\u0017\u0010F\u00026}}BQ!\u000f\u0003A\u0002eAQa\u000f\u0003A\u0002-\nQ\"\u001a8d_\u0012,g)Y:u\u0005V4GcA\u001bC\u0007\")\u0011(\u0002a\u00013!)1(\u0002a\u0001W\u0005yA-Z2pI\u00164\u0015m\u001d;BeJ\f\u0017\u0010F\u0002\u001a\r\u001eCQ!\n\u0004A\u0002\u0019BQA\u000b\u0004A\u0002-\nQ\u0002Z3d_\u0012,g)Y:u\u0005V4GcA\rK\u0017\")Qe\u0002a\u0001M!)!f\u0002a\u0001W\u0001")
public abstract class StringCodecFast {
    public String decodeFast(int len, ByteBuffer buf) {
        return buf.hasArray() ? this.decodeFastArray(len, buf) : this.decodeFastBuf(len, buf);
    }

    public void encodeFast(String s, ByteBuffer bb) {
        if (bb.hasArray()) {
            this.encodeFastArray(s, bb);
        } else {
            this.encodeFastBuf(s, bb);
        }
    }

    public void encodeFastArray(String s, ByteBuffer bb) {
        int len = s.length();
        byte[] buf = bb.array();
        int dst = bb.arrayOffset() + bb.position();
        int src = 0;
        int c = 32;
        while (src < len && (c = (int)s.charAt(src)) < 128) {
            buf[dst] = (byte)c;
            ++src;
            ++dst;
        }
        while (src < len) {
            c = s.charAt(src);
            if (c < 128) {
                buf[dst] = (byte)c;
                ++dst;
            } else if (c < 16384) {
                buf[dst] = (byte)(0x80 | c & 0x3F);
                buf[dst + 1] = (byte)(c >> 6 & 0xFF);
                dst += 2;
            } else {
                buf[dst] = (byte)(0xC0 | c & 0x3F);
                buf[dst + 1] = (byte)(c >> 6 & 0xFF);
                buf[dst + 2] = (byte)(c >> 14);
                dst += 3;
            }
            ++src;
        }
        bb.position(dst - bb.arrayOffset());
    }

    public void encodeFastBuf(String s, ByteBuffer bb) {
        int src;
        int len = s.length();
        int c = 32;
        for (src = 0; src < len && (c = (int)s.charAt(src)) < 128; ++src) {
            bb.put((byte)c);
        }
        while (src < len) {
            ByteBuffer byteBuffer;
            c = s.charAt(src);
            if (c < 128) {
                byteBuffer = bb.put((byte)c);
            } else if (c < 16384) {
                bb.put((byte)(0x80 | c & 0x3F));
                byteBuffer = bb.put((byte)(c >> 6 & 0xFF));
            } else {
                bb.put((byte)(0xC0 | c & 0x3F));
                bb.put((byte)(c >> 6 & 0xFF));
                byteBuffer = bb.put((byte)(c >> 14));
            }
            ++src;
        }
    }

    public String decodeFastArray(int len, ByteBuffer buf) {
        char[] cp = new char[len];
        byte[] src = buf.array();
        int offset = buf.arrayOffset() + buf.position();
        for (int dst = 0; dst < len; ++dst) {
            byte b = src[offset];
            ++offset;
            if ((b & 0x80) == 0) {
                cp[dst] = (char)(b & 0x7F);
                continue;
            }
            if ((b & 0xC0) == 128) {
                byte b1 = src[offset];
                ++offset;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6);
                continue;
            }
            byte b1 = src[offset];
            byte b2 = src[offset + 1];
            offset += 2;
            cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6 | b2 << 14);
        }
        buf.position(offset - buf.arrayOffset());
        return new String(cp);
    }

    public String decodeFastBuf(int len, ByteBuffer buf) {
        char[] cp = new char[len];
        int i = 0;
        for (int dst = 0; dst < len; ++dst) {
            byte b = buf.get();
            if ((b & 0x80) == 0) {
                cp[dst] = (char)(b & 0x7F);
            } else if ((b & 0xC0) == 128) {
                byte b1 = buf.get();
                ++i;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6);
            } else {
                byte b1 = buf.get();
                byte b2 = buf.get();
                i += 2;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6 | b2 << 14);
            }
            ++i;
        }
        return new String(cp);
    }
}

