/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.util.Util;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CCLTreeNode
extends DefaultMutableTreeNode {
    public CCLTreeNode() {
        super("");
    }

    public CCLTreeNode(Object oUser_) {
        super(oUser_);
    }

    public CCLTreeNode(String sPath_, char cDelimiter_) {
        this(Util.stringToLines(sPath_, cDelimiter_));
    }

    public CCLTreeNode(Vector vPathElements_) {
        Util.panicIf(vPathElements_ == null || vPathElements_.size() < 1);
        String sName = (String)vPathElements_.elementAt(0);
        this.setUserObject(sName);
        vPathElements_.removeElementAt(0);
        this.add(vPathElements_);
    }

    public CCLTreeNode get(String sFullName_, char cDelimiter_) {
        return this.get(Util.stringToLines(sFullName_, cDelimiter_));
    }

    public CCLTreeNode get(Vector vNodeNames_) {
        if (vNodeNames_.size() == 0) {
            return this;
        }
        String sName = (String)vNodeNames_.elementAt(0);
        int child = 0;
        while (child < this.getChildCount()) {
            CCLTreeNode tnNextChild = (CCLTreeNode)this.getChildAt(child);
            if (sName.equals(tnNextChild.toString())) {
                Vector vChild = (Vector)vNodeNames_.clone();
                vChild.removeElementAt(0);
                return tnNextChild.get(vChild);
            }
            ++child;
        }
        return null;
    }

    public String getName(char cSeparator_) {
        if (this.isRoot()) {
            return new String(this.toString());
        }
        if (((CCLTreeNode)this.getParent()).isRoot()) {
            return new String(this.toString());
        }
        return ((CCLTreeNode)this.getParent()).getName(cSeparator_) + cSeparator_ + this.toString();
    }

    public void add(String sPath_, char cDelimiter_) {
        this.add(Util.stringToLines(sPath_, cDelimiter_));
    }

    public void add(Vector vChild_) {
        if (vChild_ == null || vChild_.size() == 0) {
            return;
        }
        String sChild = (String)vChild_.elementAt(0);
        int childrenCount = this.getChildCount();
        int child = 0;
        while (child < childrenCount) {
            CCLTreeNode tnNextChild = (CCLTreeNode)this.getChildAt(child);
            if (sChild.equals(tnNextChild.toString())) {
                vChild_.removeElementAt(0);
                tnNextChild.add(vChild_);
                return;
            }
            if (sChild.compareTo(tnNextChild.toString()) < 0) {
                this.insert(new CCLTreeNode(vChild_), child);
                return;
            }
            ++child;
        }
        this.add(new CCLTreeNode(vChild_));
    }

    public Object clone() {
        CCLTreeNode tnClone = new CCLTreeNode(new String(this.toString()));
        int child = 0;
        while (child < this.getChildCount()) {
            TreeNode tnNextChild = this.getChildAt(child);
            tnClone.add((MutableTreeNode)((CCLTreeNode)tnNextChild).clone());
            ++child;
        }
        return tnClone;
    }

    public String toString(char cSeparator_) {
        TreeNode[] aoNode = this.getPath();
        String sRetVal = aoNode[0].toString();
        int index = 1;
        while (index < aoNode.length) {
            sRetVal = sRetVal + "." + aoNode[index];
            ++index;
        }
        return sRetVal;
    }
}

