/*
 * Decompiled with CFR 0.152.
 */
package ccl.util.test;

import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public class SToLAndConcatTest
extends Test {
    private void _checkToManyLinesBug() throws Exception {
        URL url = this.getClass().getResource("string2lines_test2.txt");
        String sTest = FileUtil.readFile(url);
        this.assert(sTest.length() == 2, "Test file has text length of " + sTest.length() + " instead of 2.");
        InputStream stream = FileUtil.getResourceAsStream(this, "string2lines_test2.txt");
        String sContent2 = FileUtil.readStream(stream);
        this.bugIf(sContent2 == null);
        this.assert(sContent2.length() == 2, "Test resource has text length of " + sContent2.length() + " instead of 2.");
        String sContent = FileUtil.getResourceAsString(this, "string2lines_test2.txt");
        this.bugIf(sContent == null);
        this.assert(sContent.length() == 2, "Test resource has text length of " + sContent.length() + " instead of 2.");
        url = this.getClass().getResource("string2lines_test.txt");
        sTest = FileUtil.readFile(url);
        this.bugIf(sTest == null);
        Vector vTest = Util.stringToLines(sTest);
        this.assert(vTest.size() == 18, "Vector size should be 18 but is " + vTest.size());
        sTest = FileUtil.getResourceAsString(this, "string2lines_test3.txt");
        this.bugIf(sTest == null);
        vTest = Util.stringToLines(sTest);
        this.assert(vTest.size() == 1, "Vector size should be 1 but is " + vTest.size());
        sTest = FileUtil.getResourceAsString(this, "string2lines_test.txt");
        this.bugIf(sTest == null);
        vTest = Util.stringToLines(sTest);
        this.assert(vTest.size() == 18, "Vector size should be 18 but is " + vTest.size());
    }

    public SToLAndConcatTest() {
    }

    public SToLAndConcatTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        this._checkToManyLinesBug();
        String[] asTest = new String[8];
        Vector[] avTest = new Vector[8];
        int[] aTestSize = new int[8];
        int[] aControlSize = new int[8];
        asTest[0] = "H:\\eigen\\src\\JAVA\\jamacs\\Jamacs.prj\nH:\\eigen\\go\\Jactor\\Collector.prj;H:\\eigen\\SOCCER\\semifinal\\Semifinal.prj;\nj:\\softwarehelp\\language-spec.hlp";
        asTest[1] = asTest[0] + "\n";
        asTest[2] = asTest[1] + "\n";
        asTest[3] = "";
        asTest[4] = new String();
        asTest[5] = " ";
        asTest[6] = "ganz Normaler Text";
        asTest[7] = null;
        aControlSize[0] = 3;
        aControlSize[1] = 3;
        aControlSize[2] = 4;
        aControlSize[3] = 0;
        aControlSize[4] = 0;
        aControlSize[5] = 1;
        aControlSize[6] = 1;
        aControlSize[7] = 0;
        String sErg1 = "H:\\eigen\\src\\JAVA\\jamacs\\Jamacs.prjH:\\eigen\\go\\Jactor\\Collector.prj;H:\\eigen\\SOCCER\\semifinal\\Semifinal.prj;j:\\softwarehelp\\language-spec.hlp";
        int test = 0;
        while (test < asTest.length) {
            avTest[test] = Util.stringToLines(asTest[test]);
            aTestSize[test] = avTest[test].size();
            ++test;
        }
        int test2 = 0;
        while (test2 < asTest.length) {
            this.bugIf(aTestSize[test2] != aControlSize[test2]);
            ++test2;
        }
        if (this.bugIf(!Util.concat(avTest[1], "\n").equals(asTest[0]))) {
            Util.println("Test0: " + avTest[0]);
            Util.println("Test1: " + avTest[1]);
            Util.println("Concat Test0: " + Util.concat(avTest[0], "\n"));
            Util.println("asTest[1]: " + asTest[1]);
        }
        if (this.bugIf(!Util.concat(avTest[2]).equals(Util.concat(avTest[0])))) {
            Util.println("Test0: " + avTest[0]);
            Util.println("Test1: " + avTest[1]);
            Util.println("Test2: " + avTest[2]);
            Util.println("Concat Test0: " + Util.concat(avTest[0]) + "*");
            Util.println("Concat Test2: " + Util.concat(avTest[2]) + "*");
            Util.println("asTest0: " + asTest[0] + "*");
        }
        this.bugIf(!Util.concat(avTest[1]).equals(sErg1));
        this.bugIf(!Util.concat(avTest[0]).equals(sErg1));
        this.bugIf(!sErg1.equals(Util.concat(avTest[2])));
        this.bugIf(!Util.concat(null).equals(""));
        this.bugIf(!new String().equals(""));
        this.bugIf(!Util.concat(new Vector(), (String)null).equals(""));
        Vector<String> vTest = new Vector<String>();
        vTest.addElement("kjh");
        vTest.addElement("kjh");
        this.bugIf(!Util.concat(vTest, (String)null).equals("kjhkjh"));
    }

    public static void main(String[] args) {
        SToLAndConcatTest pTest = new SToLAndConcatTest();
        pTest.setTiming(true);
        pTest.setVerbose(true);
        pTest.run();
        Test.printResult(pTest);
        System.exit(0);
    }
}

