package org.jboss.cache.lock;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;

/**
 * @author Bela Ban
 * @version $Id: BelasLockStrategy.java,v 1.1 2005/02/25 19:52:26 belaban Exp $
 */
public class BelasLockStrategy implements LockStrategy {
   ReentrantWriterPreferenceReadWriteLock lock=new ReentrantWriterPreferenceReadWriteLock();

   public BelasLockStrategy() {
   }

   public Sync readLock() {
      return lock.readLock();
   }

   public Sync writeLock() {
      return lock.writeLock();
   }

   public Sync upgradeLockAttempt(long msecs) throws UpgradeException {
      boolean acquired;
      Sync    writeLock=lock.writeLock();

      try {
         acquired=writeLock.attempt(msecs);
         if(acquired) {
            lock.readLock().release();
            return writeLock;
         }
         else {
            return null;
         }
      }
      catch(InterruptedException iex) {
         throw new UpgradeException("failed upgrading lock", iex);
      }
   }
}
