/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.tests;

import junit.framework.Test;
import junit.framework.TestSuite;

import java.util.Properties;

/**
 * This test has MySQL hard-coded. To run it, run MySQL first: mysqld -u=root
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision: 1.5 $</tt>
 */
public class JDBCCacheLoaderTest
   extends CacheLoaderTestsBase
{

   protected void configureCache() throws Exception
   {
      cache.setCacheLoaderClass("org.jboss.cache.loader.JDBCCacheLoader");
      Properties props=new Properties();
      // hard-coding MySQL for now...
      props.setProperty("cache.jdbc.driver", "com.mysql.jdbc.Driver");
      props.setProperty("cache.jdbc.url", "jdbc:mysql://localhost:3306/jbossdb");
      props.setProperty("cache.jdbc.user", "root");
      props.setProperty("cache.jdbc.password", "");
      cache.setCacheLoaderConfig(props);
   }

   public static Test suite()
   {
      return new TestSuite(JDBCCacheLoaderTest.class);
   }
}
