package org.jboss.cache.tests;

import org.jboss.cache.TreeCache;
import org.jboss.cache.Fqn;

/**
 * @author Bela Ban
 * @version $Id: RpcDelegatingCacheLoaderTests.java,v 1.3 2005/03/12 15:14:38 belaban Exp $
 */
public class RpcDelegatingCacheLoaderTests {
   TreeCache cache;


   public static void main(String[] args) {
      boolean client=false;

      for(int i=0; i < args.length; i++) {
         String arg=args[i];
         if(arg.equals("client")) {
            client=true;
            continue;
         }
         if(arg.equals("server")) {
            client=false;
            continue;
         }
         help();
         return;
      }

      try {
         new RpcDelegatingCacheLoaderTests().start(client);
      }
      catch(Exception e) {
         e.printStackTrace();
      }
   }

   private static void help() {
      System.out.println("RpcDelegatingCacheLoadeTest [client / server]");
   }

   private void start(boolean client) throws Exception {
      cache=new TreeCache("test-cluster", null, 3000);
      cache.setCacheMode(TreeCache.REPL_ASYNC);
      cache.setFetchStateOnStartup(true);
      cache.setCacheLoaderFetchTransientState(true);
      cache.setCacheLoaderClass("org.jboss.cache.loader.RpcDelegatingCacheLoader");
      cache.setCacheLoaderShared(false);
      cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      cache.startService();

      if(client == false) {
         System.out.println("started as SERVER");
         System.out.println("populating the cache");
         cache.getTransactionManager().begin();
         cache.put("/a/b/c", "bela", "ban");
         cache.put("/1/2/3", "ben", "wang");
         cache.getTransactionManager().commit();
         System.out.println("the cache is " + cache.toString() + ", locks: " + cache.printLockInfo());

         while(true){
            sleep(2000);
            cache.getTransactionManager().begin();
            cache.put("/x/y/z", "d", "d");
            cache.getTransactionManager().commit();
         }
      }

      System.out.println("started as CLIENT");
      System.out.println("initial cache (fetched from SERVER) is " + cache.printLockInfo());
//      int i=1;
//      while(true) {
//         cache.put("/elements/" + i, "key", "value");
//         sleep(1000);
//         cache.evict(Fqn.fromString("/elements/" + i));
//         i++;
//      }

      // sleep a bit, because we use async repl, changes from the server may not yet have arrived
      sleep(1000);

      System.out.println("evicting /a and /1 locally");
      cache.evict(Fqn.fromString("/a/b/c"));
      cache.evict(Fqn.fromString("/a/b"));
      cache.evict(Fqn.fromString("/a"));
      cache.evict(Fqn.fromString("/1/2/3"));
      cache.evict(Fqn.fromString("/1/2"));
      cache.evict(Fqn.fromString("/1"));
      System.out.println("cache contents after eviction: " + cache.printLockInfo());

      System.out.println("accessing /a and /1. this will trigger a fetch from the remote SERVER");
      Object val=cache.get("/a/b/c", "bela");
      System.out.println("value is " + val);

      val=cache.get("/1/2/3", "ben");
      System.out.println("value is " + val);

      System.out.println("the cache is " + cache.toString() + ", locks: " + cache.printLockInfo());
   }


   private void sleep(long time) {
      try {
         Thread.sleep(time);
      }
      catch(InterruptedException e) {
      }
   }
}
