/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;

public class ObjectNamePatternHelper {
    public static boolean patternMatch(ObjectName test, ObjectName pattern) {
        if (pattern.equals("*:*")) {
            return true;
        }
        if (ObjectNamePatternHelper.patternMatch(test.getDomain(), pattern.getDomain())) {
            PropertyPattern propertyPattern = new PropertyPattern(pattern);
            return propertyPattern.patternMatch(test);
        }
        return false;
    }

    public static boolean patternMatch(String test, String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        return ObjectNamePatternHelper.patternMatch(test.toCharArray(), 0, pattern.toCharArray(), 0);
    }

    public static boolean patternMatch(char[] test, int tpos, char[] pattern, int ppos) {
        int tlen = test.length;
        int plen = pattern.length;
        while (ppos < plen) {
            char c;
            if ('?' == (c = pattern[ppos++])) {
                if (tpos++ != tlen) continue;
                return false;
            }
            if ('*' == c) {
                if (ppos == plen) {
                    return true;
                }
                do {
                    if (!ObjectNamePatternHelper.patternMatch(test, tpos, pattern, ppos)) continue;
                    return true;
                } while (++tpos < tlen);
                continue;
            }
            if (tpos != tlen && c == test[tpos++]) continue;
            return false;
        }
        return tpos == tlen;
    }

    public static class PropertyPattern {
        boolean isPropertyPattern;
        Object[] propertyKeys;
        Object[] propertyValues;
        String canonicalKeyPropertyString;

        public PropertyPattern(ObjectName pattern) {
            this.isPropertyPattern = pattern.isPropertyPattern();
            if (this.isPropertyPattern) {
                Hashtable patternKPList = pattern.getKeyPropertyList();
                int length = patternKPList.size();
                this.propertyKeys = new Object[length];
                this.propertyValues = new Object[length];
                int i = 0;
                Iterator iterator = patternKPList.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.propertyKeys[i] = entry.getKey();
                    this.propertyValues[i] = entry.getValue();
                    ++i;
                }
            } else {
                this.canonicalKeyPropertyString = pattern.getCanonicalKeyPropertyListString();
            }
        }

        public boolean patternMatch(ObjectName name) {
            if (this.isPropertyPattern) {
                if (this.propertyKeys.length == 0) {
                    return true;
                }
                Hashtable kplist = name.getKeyPropertyList();
                for (int i = 0; i < this.propertyKeys.length; ++i) {
                    if (this.propertyValues[i].equals(kplist.get(this.propertyKeys[i]))) continue;
                    return false;
                }
                return true;
            }
            return this.canonicalKeyPropertyString.equals(name.getCanonicalKeyPropertyListString());
        }
    }
}

