/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.FragHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Util;

public class FRAG
extends Protocol {
    private int frag_size = 8192;
    private final FragmentationList fragment_list = new FragmentationList();
    private int curr_id = 1;
    private final ExposedByteArrayOutputStream bos = new ExposedByteArrayOutputStream(1024);
    private final Vector members = new Vector(11);
    private static final String name = "FRAG";

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("frag_size");
        if (str != null) {
            this.frag_size = Integer.parseInt(str);
            props.remove("frag_size");
        }
        if (props.size() > 0) {
            System.err.println("FRAG.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                long size = msg.size();
                if (size <= (long)this.frag_size) break;
                if (this.log.isTraceEnabled()) {
                    StringBuffer sb = new StringBuffer("message size is ");
                    sb.append(size).append(", will fragment (frag_size=").append(this.frag_size).append(')');
                    this.log.trace((Object)sb.toString());
                }
                this.fragment(msg);
                return;
            }
            case 6: {
                View view = (View)evt.getArg();
                Vector new_mbrs = view.getMembers();
                Vector left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
                this.members.clear();
                this.members.addAll(new_mbrs);
                for (int i = 0; i < left_mbrs.size(); ++i) {
                    Address mbr = (Address)left_mbrs.elementAt(i);
                    this.fragment_list.remove(mbr);
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("[VIEW_CHANGE] removed " + mbr + " from fragmentation table"));
                }
                break;
            }
            case 56: {
                this.passDown(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(name);
                if (obj == null || !(obj instanceof FragHeader)) break;
                this.unfragment(msg);
                return;
            }
            case 56: {
                this.passUp(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fragment(Message msg) {
        DataOutputStream out = null;
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        long id = this.curr_id++;
        try {
            this.bos.reset();
            out = new DataOutputStream(this.bos);
            msg.writeTo(out);
            out.flush();
            byte[] buffer = this.bos.getRawBuffer();
            byte[][] fragments = Util.fragmentBuffer(buffer, this.frag_size, this.bos.size());
            int num_frags = fragments.length;
            if (this.log.isTraceEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("fragmenting packet to ").append(dest != null ? dest.toString() : "<all members>");
                sb.append(" (size=").append(buffer.length).append(") into ").append(num_frags);
                sb.append(" fragment(s) [frag_size=").append(this.frag_size).append(']');
                this.log.trace((Object)sb.toString());
            }
            for (int i = 0; i < num_frags; ++i) {
                Message frag_msg = new Message(dest, src, fragments[i]);
                FragHeader hdr = new FragHeader(id, i, num_frags);
                frag_msg.putHeader(name, hdr);
                Event evt = new Event(1, frag_msg);
                this.passDown(evt);
            }
        }
        catch (Exception e) {
            try {
                this.log.error((Object)("exception is " + e));
            }
            catch (Throwable throwable) {
                Util.closeOutputStream(out);
                throw throwable;
            }
            Util.closeOutputStream(out);
        }
        Util.closeOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unfragment(Message msg) {
        byte[] m;
        FragmentationTable frag_table = null;
        Address sender = msg.getSrc();
        FragHeader hdr = (FragHeader)msg.removeHeader(name);
        DataInputStream in = null;
        frag_table = this.fragment_list.get(sender);
        if (frag_table == null) {
            frag_table = new FragmentationTable(sender);
            try {
                this.fragment_list.add(sender, frag_table);
            }
            catch (IllegalArgumentException x) {
                frag_table = this.fragment_list.get(sender);
            }
        }
        if ((m = frag_table.add(hdr.id, hdr.frag_id, hdr.num_frags, msg.getBuffer())) != null) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(m);
                in = new DataInputStream(bis);
                Message assembled_msg = new Message();
                assembled_msg.readFrom(in);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("assembled_msg is " + assembled_msg));
                }
                assembled_msg.setSrc(sender);
                this.passUp(new Event(1, assembled_msg));
            }
            catch (Exception e) {
                try {
                    this.log.error((Object)("exception is " + e));
                }
                catch (Throwable throwable) {
                    Util.closeInputStream(in);
                    throw throwable;
                }
                Util.closeInputStream(in);
            }
            Util.closeInputStream(in);
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.frag_size = (Integer)map.get("frag_size");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("setting frag_size=" + this.frag_size));
            }
        }
    }

    static class FragmentationTable {
        private final Address sender;
        private final Hashtable h = new Hashtable(11);

        public FragmentationTable(Address sender) {
            this.sender = sender;
        }

        public synchronized byte[] add(long id, int frag_id, int tot_frags, byte[] fragment) {
            byte[] retval = null;
            Entry e = (Entry)this.h.get(new Long(id));
            if (e == null) {
                e = new Entry(id, tot_frags);
                this.h.put(new Long(id), e);
            }
            e.set(frag_id, fragment);
            if (e.isComplete()) {
                retval = e.assembleBuffer();
                this.h.remove(new Long(id));
            }
            return retval;
        }

        public void reset() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("Fragmentation Table Sender:").append(this.sender).append("\n\t");
            Enumeration e = this.h.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                int count = 0;
                for (int i = 0; i < entry.fragments.length; ++i) {
                    if (entry.fragments[i] == null) continue;
                    ++count;
                }
                buf.append("Message ID:").append(entry.msg_id).append("\n\t");
                buf.append("Total Frags:").append(entry.tot_frags).append("\n\t");
                buf.append("Frags Received:").append(count).append("\n\n");
            }
            return buf.toString();
        }

        static class Entry {
            int tot_frags = 0;
            byte[][] fragments = null;
            int number_of_frags_recvd = 0;
            long msg_id = -1L;

            Entry(long msg_id, int tot_frags) {
                this.msg_id = msg_id;
                this.tot_frags = tot_frags;
                this.fragments = new byte[tot_frags][];
                for (int i = 0; i < tot_frags; ++i) {
                    this.fragments[i] = null;
                }
            }

            public void set(int frag_id, byte[] frag) {
                this.fragments[frag_id] = frag;
                ++this.number_of_frags_recvd;
            }

            public boolean isComplete() {
                if (this.number_of_frags_recvd < this.tot_frags) {
                    return false;
                }
                for (int i = 0; i < this.fragments.length; ++i) {
                    if (this.fragments[i] != null) continue;
                    return false;
                }
                return true;
            }

            public byte[] assembleBuffer() {
                return Util.defragmentBuffer(this.fragments);
            }

            public String toString() {
                StringBuffer ret = new StringBuffer();
                ret.append("[tot_frags=" + this.tot_frags + ", number_of_frags_recvd=" + this.number_of_frags_recvd + ']');
                return ret.toString();
            }

            public int hashCode() {
                return super.hashCode();
            }
        }
    }

    static class FragmentationList {
        private final HashMap frag_tables = new HashMap(11);

        FragmentationList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Address sender, FragmentationTable table) throws IllegalArgumentException {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                FragmentationTable healthCheck = (FragmentationTable)this.frag_tables.get(sender);
                if (healthCheck != null) {
                    throw new IllegalArgumentException("Sender <" + sender + "> already exists in the fragementation list.");
                }
                this.frag_tables.put(sender, table);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FragmentationTable get(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                return (FragmentationTable)this.frag_tables.get(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsSender(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                return this.frag_tables.containsKey(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                boolean result = this.containsSender(sender);
                this.frag_tables.remove(sender);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Address[] getSenders() {
            Address[] result;
            int index = 0;
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                result = new Address[this.frag_tables.size()];
                Iterator it = this.frag_tables.keySet().iterator();
                while (it.hasNext()) {
                    result[index++] = (Address)it.next();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer buf = new StringBuffer("Fragmentation list contains ");
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                buf.append(this.frag_tables.size()).append(" tables\n");
                Iterator it = this.frag_tables.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    buf.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
            }
            return buf.toString();
        }
    }
}

