/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.protocols.Receiver;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.stack.LogicalAddress1_4;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

public class UDP1_4
extends Protocol
implements Receiver {
    static final String name = "UDP1_4";
    ConnectorTable ct = null;
    List bind_addrs = null;
    String group_name = null;
    InetSocketAddress mcast_addr = null;
    LogicalAddress1_4 local_addr = new LogicalAddress1_4(null, null);
    LogicalAddress1_4 local_addr_canonical = this.local_addr.copy();
    ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);
    int local_bind_port = 0;
    int port_range = 1;
    boolean ip_mcast = true;
    int ip_ttl = 32;
    Vector members = new Vector();
    UdpHeader udp_hdr = null;
    int mcast_send_buf_size = 300000;
    int mcast_recv_buf_size = 300000;
    int ucast_send_buf_size = 300000;
    int ucast_recv_buf_size = 300000;
    boolean loopback = true;
    boolean use_packet_handler = false;
    Queue packet_queue = null;
    byte[] additional_data = null;
    PacketHandler packet_handler = null;
    protected static Log mylog = LogFactory.getLog((Class)UDP1_4.class);
    final int VERSION_LENGTH = Version.getLength();
    static final int DEFAULT_RECEIVE_BUFFER_SIZE = 120000;

    public String toString() {
        return "Protocol UDP(local address: " + this.local_addr + ')';
    }

    public void receive(DatagramPacket packet) {
        SocketAddress sender;
        byte[] data;
        block6: {
            int len = packet.getLength();
            data = packet.getData();
            sender = packet.getSocketAddress();
            if (len == 4 && data[0] == 100 && data[1] == 105 && data[2] == 97 && data[3] == 103) {
                this.handleDiagnosticProbe(sender);
                return;
            }
            if (mylog.isTraceEnabled()) {
                mylog.trace((Object)("received " + len + " bytes from " + sender));
            }
            if (!Version.compareTo(packet.getData()) && mylog.isWarnEnabled()) {
                mylog.warn((Object)("packet from " + sender + " has different version (" + Version.printVersionId(data, Version.version_id.length) + ") from ours (" + Version.printVersionId(Version.version_id) + "). This may cause problems"));
            }
            if (this.use_packet_handler && this.packet_queue != null) {
                byte[] tmp = new byte[len];
                System.arraycopy(data, 0, tmp, 0, len);
                try {
                    Object[] arr = new Object[]{tmp, sender};
                    this.packet_queue.add(arr);
                    return;
                }
                catch (QueueClosedException e) {
                    if (!mylog.isWarnEnabled()) break block6;
                    mylog.warn((Object)"packet queue for packet handler thread is closed");
                }
            }
        }
        this.handleIncomingUdpPacket(data, sender);
    }

    void handleDiagnosticProbe(SocketAddress sender) {
        block3: {
            try {
                byte[] diag_rsp = this.getDiagResponse().getBytes();
                DatagramPacket rsp = new DatagramPacket(diag_rsp, 0, diag_rsp.length, sender);
                if (mylog.isInfoEnabled()) {
                    mylog.info((Object)("sending diag response to " + sender));
                }
                this.ct.send(rsp);
            }
            catch (Throwable t) {
                if (!mylog.isErrorEnabled()) break block3;
                mylog.error((Object)("failed sending diag rsp to " + sender + ", exception=" + t));
            }
        }
    }

    String getDiagResponse() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.local_addr).append(" (").append(this.group_name).append(')');
        sb.append(" [").append(this.mcast_addr).append("]\n");
        sb.append("Version=").append("2.2.8").append(", cvs=\"").append("$Id: Version.java,v 1.18.2.1 2005/05/30 09:47:56 belaban Exp $").append("\"\n");
        sb.append("physical addresses: ").append(this.local_addr.getPhysicalAddresses()).append('\n');
        sb.append("members: ").append(this.members).append('\n');
        return sb.toString();
    }

    public String getName() {
        return name;
    }

    public void init() throws Exception {
        if (this.use_packet_handler) {
            this.packet_queue = new Queue();
            this.packet_handler = new PacketHandler();
        }
    }

    public void start() throws Exception {
        if (mylog.isInfoEnabled()) {
            mylog.info((Object)"creating sockets and starting threads");
        }
        if (this.ct == null) {
            this.ct = new ConnectorTable(this.mcast_addr, 120000, this.mcast_recv_buf_size, this.ip_mcast, this);
            Iterator it = this.bind_addrs.iterator();
            while (it.hasNext()) {
                String bind_addr = (String)it.next();
                this.ct.listenOn(bind_addr, this.local_bind_port, this.port_range, 120000, this.ucast_recv_buf_size, this.ucast_send_buf_size, this.ip_ttl, this);
            }
            List physical_addrs = this.ct.getConnectorAddresses();
            Iterator it2 = physical_addrs.iterator();
            while (it2.hasNext()) {
                SocketAddress address = (SocketAddress)it2.next();
                this.local_addr.addPhysicalAddress(address);
            }
            if (this.additional_data != null) {
                this.local_addr.setAdditionalData(this.additional_data);
            }
            this.ct.start();
            this.passUp(new Event(8, this.local_addr));
            if (this.use_packet_handler) {
                this.packet_handler.start();
            }
        }
    }

    public void stop() {
        if (mylog.isInfoEnabled()) {
            mylog.info((Object)"closing sockets and stopping threads");
        }
        if (this.packet_handler != null) {
            this.packet_handler.stop();
        }
        if (this.ct != null) {
            this.ct.stop();
            this.ct = null;
        }
        this.local_addr.removeAllPhysicalAddresses();
    }

    public boolean setProperties(Properties props) {
        List exclude_list;
        block27: {
            exclude_list = null;
            String mcast_addr_name = "230.8.8.8";
            int mcast_port = 7500;
            super.setProperties(props);
            String str = props.getProperty("bind_addrs");
            if (str != null) {
                if ("all".equals((str = str.trim()).toLowerCase())) {
                    try {
                        this.bind_addrs = this.determineAllBindInterfaces();
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                        this.bind_addrs = null;
                    }
                } else {
                    this.bind_addrs = Util.parseCommaDelimitedStrings(str);
                }
                props.remove("bind_addrs");
            }
            if ((str = props.getProperty("bind_addrs_exclude")) != null) {
                str = str.trim();
                exclude_list = Util.parseCommaDelimitedStrings(str);
                props.remove("bind_addrs_exclude");
            }
            if ((str = props.getProperty("bind_port")) != null) {
                this.local_bind_port = Integer.parseInt(str);
                props.remove("bind_port");
            }
            if ((str = props.getProperty("start_port")) != null) {
                this.local_bind_port = Integer.parseInt(str);
                props.remove("start_port");
            }
            if ((str = props.getProperty("port_range")) != null) {
                this.port_range = Integer.parseInt(str);
                props.remove("port_range");
            }
            if ((str = props.getProperty("mcast_addr")) != null) {
                mcast_addr_name = str;
                props.remove("mcast_addr");
            }
            if ((str = props.getProperty("mcast_port")) != null) {
                mcast_port = Integer.parseInt(str);
                props.remove("mcast_port");
            }
            if ((str = props.getProperty("ip_mcast")) != null) {
                this.ip_mcast = Boolean.valueOf(str);
                props.remove("ip_mcast");
            }
            if ((str = props.getProperty("ip_ttl")) != null) {
                this.ip_ttl = Integer.parseInt(str);
                props.remove("ip_ttl");
            }
            if ((str = props.getProperty("mcast_send_buf_size")) != null) {
                this.mcast_send_buf_size = Integer.parseInt(str);
                props.remove("mcast_send_buf_size");
            }
            if ((str = props.getProperty("mcast_recv_buf_size")) != null) {
                this.mcast_recv_buf_size = Integer.parseInt(str);
                props.remove("mcast_recv_buf_size");
            }
            if ((str = props.getProperty("ucast_send_buf_size")) != null) {
                this.ucast_send_buf_size = Integer.parseInt(str);
                props.remove("ucast_send_buf_size");
            }
            if ((str = props.getProperty("ucast_recv_buf_size")) != null) {
                this.ucast_recv_buf_size = Integer.parseInt(str);
                props.remove("ucast_recv_buf_size");
            }
            if ((str = props.getProperty("use_packet_handler")) != null) {
                this.use_packet_handler = Boolean.valueOf(str);
                props.remove("use_packet_handler");
            }
            this.mcast_addr = new InetSocketAddress(mcast_addr_name, mcast_port);
            if (this.bind_addrs == null) {
                this.bind_addrs = new ArrayList();
            }
            if (this.bind_addrs.size() == 0) {
                try {
                    String default_bind_addr = this.determineDefaultBindInterface();
                    this.bind_addrs.add(default_bind_addr);
                }
                catch (SocketException ex) {
                    if (!mylog.isErrorEnabled()) break block27;
                    mylog.error((Object)("failed determining the default bind interface: " + ex));
                }
            }
        }
        if (exclude_list != null) {
            this.bind_addrs.removeAll(exclude_list);
        }
        if (this.bind_addrs.size() == 0) {
            if (mylog.isErrorEnabled()) {
                mylog.error((Object)"no valid bind interface found, unable to listen for network traffic");
            }
            return false;
        }
        if (mylog.isInfoEnabled()) {
            mylog.info((Object)("bind interfaces are " + this.bind_addrs));
        }
        if (props.size() > 0) {
            System.err.println("UDP1_4.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void startUpHandler() {
    }

    public void up(Event evt) {
        this.passUp(evt);
        switch (evt.getType()) {
            case 56: {
                this.passUp(evt);
                if (mylog.isInfoEnabled()) {
                    mylog.info((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        block6: {
            if (evt.getType() != 1) {
                this.handleDownEvent(evt);
                return;
            }
            Message msg = (Message)evt.getArg();
            if (this.udp_hdr != null && this.udp_hdr.channel_name != null) {
                msg.putHeader(name, this.udp_hdr);
            }
            Address dest_addr = msg.getDest();
            if (this.observer != null) {
                this.observer.passDown(evt);
            }
            if (dest_addr == null && !this.ip_mcast) {
                this.sendMultipleUdpMessages(msg, this.members);
                return;
            }
            try {
                this.sendUdpMessage(msg);
            }
            catch (Exception e) {
                if (!mylog.isErrorEnabled()) break block6;
                mylog.error((Object)("exception=" + e + ", msg=" + msg + ", mcast_addr=" + this.mcast_addr));
            }
        }
    }

    void handleMessage(Message msg) {
    }

    void handleIncomingUdpPacket(byte[] data, SocketAddress sender) {
        Event evt;
        Message msg = null;
        UdpHeader hdr = null;
        try {
            ByteArrayInputStream inp_stream = new ByteArrayInputStream(data, this.VERSION_LENGTH, data.length - this.VERSION_LENGTH);
            ObjectInputStream inp = new ObjectInputStream(inp_stream);
            msg = new Message();
            msg.readExternal(inp);
            Address dst = msg.getDest();
            Address src = msg.getSrc();
            if (src == null) {
                if (mylog.isErrorEnabled()) {
                    mylog.error((Object)"sender's address is null");
                }
            } else {
                ((LogicalAddress1_4)src).setPrimaryPhysicalAddress(sender);
            }
            if ((dst == null || dst.isMulticastAddress()) && src != null && this.local_addr.equals(src)) {
                if (mylog.isTraceEnabled()) {
                    mylog.trace((Object)"discarded own loopback multicast packet");
                }
                return;
            }
            evt = new Event(1, msg);
            if (mylog.isTraceEnabled()) {
                mylog.trace((Object)("Message is " + msg + ", headers are " + msg.getHeaders()));
            }
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            hdr = (UdpHeader)msg.removeHeader(name);
        }
        catch (Throwable e) {
            if (mylog.isErrorEnabled()) {
                mylog.error((Object)("exception=" + Util.getStackTrace(e)));
            }
            return;
        }
        if (hdr != null) {
            String ch_name = null;
            if (hdr.channel_name != null) {
                ch_name = hdr.channel_name;
            }
            if (ch_name != null && this.group_name != null && !this.group_name.equals(ch_name) && !ch_name.equals("DIAG_GROUP-BELA-322649")) {
                if (mylog.isWarnEnabled()) {
                    mylog.warn((Object)("discarded message from different group (" + ch_name + "). Sender was " + msg.getSrc()));
                }
                return;
            }
        }
        this.passUp(evt);
    }

    void sendUdpMessage(Message msg) throws Exception {
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        if (src == null) {
            src = this.local_addr_canonical;
            msg.setSrc(src);
        }
        if (mylog.isTraceEnabled()) {
            mylog.trace((Object)("sending message to " + msg.getDest() + " (src=" + msg.getSrc() + "), headers are " + msg.getHeaders()));
        }
        if (dest == null || dest.isMulticastAddress() || dest.equals(this.local_addr)) {
            Message copy = msg.copy();
            copy.removeHeader(name);
            Event evt = new Event(1, copy);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            if (mylog.isTraceEnabled()) {
                mylog.trace((Object)("looped back local message " + copy));
            }
            this.passUp(evt);
            if (dest != null && !dest.isMulticastAddress()) {
                return;
            }
        }
        this.out_stream.reset();
        this.out_stream.write(Version.version_id, 0, Version.version_id.length);
        ObjectOutputStream out = new ObjectOutputStream(this.out_stream);
        msg.writeExternal(out);
        out.flush();
        byte[] buf = this.out_stream.toByteArray();
        DatagramPacket packet = new DatagramPacket(buf, buf.length, this.mcast_addr);
        this.ct.send(packet);
    }

    void sendMultipleUdpMessages(Message msg, Vector dests) {
        for (int i = 0; i < dests.size(); ++i) {
            Address dest = (Address)dests.elementAt(i);
            msg.setDest(dest);
            try {
                this.sendUdpMessage(msg);
                continue;
            }
            catch (Exception e) {
                if (!mylog.isDebugEnabled()) continue;
                mylog.debug((Object)("exception=" + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.group_name = (String)evt.getArg();
                this.udp_hdr = new UdpHeader(this.group_name);
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 56: {
                if (mylog.isInfoEnabled()) {
                    mylog.info((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
        }
    }

    public String determineDefaultBindInterface() throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> en2 = ni.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress bind_addr = en2.nextElement();
                if (bind_addr.isLoopbackAddress()) continue;
                return bind_addr.getHostAddress();
            }
        }
        return null;
    }

    public List determineAllBindInterfaces() throws SocketException {
        ArrayList<String> ret = new ArrayList<String>();
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> en2 = ni.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress bind_addr = en2.nextElement();
                ret.add(bind_addr.getHostAddress());
            }
        }
        return ret;
    }

    static void help() {
        System.out.println("UDP1_4 [-help] [-bind_addrs <list of interfaces>]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ConnectorTable ct;
        InetSocketAddress mcast_addr;
        MyReceiver r = new MyReceiver();
        BufferedReader in = null;
        int receive_buffer_size = 65000;
        boolean ip_mcast = true;
        try {
            mcast_addr = new InetSocketAddress("230.1.2.3", 7500);
            ct = new ConnectorTable(mcast_addr, receive_buffer_size, 120000, ip_mcast, r);
            r.setConnectorTable(ct);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                UDP1_4.help();
                continue;
            }
            if (!"-bind_addrs".equals(args[i])) continue;
            while (++i < args.length && !args[i].trim().startsWith("-")) {
                try {
                    ct.listenOn(args[i], 0, 1, receive_buffer_size, 120000, 12000, 32, r);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        try {
            ct.start();
            in = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.print("> ");
                System.out.flush();
                String line = in.readLine();
                if (line.startsWith("quit")) break;
                if (line.startsWith("exit")) {
                    break;
                }
                byte[] send_buf = line.getBytes();
                DatagramPacket packet = new DatagramPacket(send_buf, send_buf.length, mcast_addr);
                ct.send(packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ct != null) {
                ct.stop();
            }
        }
    }

    public static class Mailman {
    }

    public static class Unmarshaller {
        Queue q = null;

        void receive(byte[] data, SocketAddress sender) {
        }
    }

    public static class MulticastReceiver
    implements Runnable {
        Unmarshaller m = null;
        DatagramSocket sock = null;

        public void run() {
        }
    }

    public static class MyReceiver
    implements Receiver {
        ConnectorTable t = null;

        public void setConnectorTable(ConnectorTable t) {
            this.t = t;
        }

        public void receive(DatagramPacket packet) {
            System.out.println("-- received " + packet.getLength() + " bytes from " + packet.getSocketAddress());
            InetAddress sender = packet.getAddress();
            byte[] buf = packet.getData();
            int len = packet.getLength();
            String tmp = new String(buf, 0, len);
            if (len > 4 && tmp.startsWith("rsp:")) {
                System.out.println("-- received respose: \"" + tmp + '\"');
                return;
            }
            byte[] rsp_buf = ("rsp: this is a response to " + tmp).getBytes();
            DatagramPacket response = new DatagramPacket(rsp_buf, rsp_buf.length, sender, packet.getPort());
            try {
                this.t.send(response);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("MyReceiver: problem sending response to " + sender);
            }
        }
    }

    public static class ConnectorTable
    implements Receiver,
    Runnable {
        Thread t = null;
        MulticastSocket mcast_sock = null;
        InetSocketAddress mcast_addr = null;
        Receiver receiver = null;
        byte[] receive_buffer = null;
        Vector connectors = new Vector();
        boolean running = false;

        public ConnectorTable(InetSocketAddress mcast_addr, int receive_buffer_size, int receive_sock_buf_size, boolean ip_mcast, Receiver receiver) throws IOException {
            this.receiver = receiver;
            this.mcast_addr = mcast_addr;
            this.receive_buffer = new byte[receive_buffer_size];
            if (ip_mcast) {
                this.mcast_sock = new MulticastSocket(mcast_addr.getPort());
                this.mcast_sock.setReceiveBufferSize(receive_sock_buf_size);
            }
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public void start() throws Exception {
            if (this.running) {
                return;
            }
            if (this.mcast_sock != null) {
                this.t = new Thread((Runnable)this, "ConnectorTable thread");
                this.t.setDaemon(true);
                this.t.start();
            }
            Iterator it = this.connectors.iterator();
            while (it.hasNext()) {
                Connector tmp = (Connector)it.next();
                tmp.start();
            }
            this.running = true;
        }

        public void stop() {
            Iterator it = this.connectors.iterator();
            while (it.hasNext()) {
                Connector tmp = (Connector)it.next();
                tmp.stop();
            }
            this.connectors.clear();
            this.t = null;
            if (this.mcast_sock != null) {
                this.mcast_sock.close();
                this.mcast_sock = null;
            }
            this.running = false;
        }

        public void run() {
            DatagramPacket p = new DatagramPacket(this.receive_buffer, this.receive_buffer.length);
            while (this.t != null && this.mcast_sock != null && !this.mcast_sock.isClosed()) {
                p.setData(this.receive_buffer, 0, this.receive_buffer.length);
                try {
                    ConnectorTable.receivePacket(p, this.mcast_sock, this);
                }
                catch (Throwable t) {
                    if (t == null || this.mcast_sock == null || this.mcast_sock.isClosed()) break;
                    if (mylog.isErrorEnabled()) {
                        mylog.error((Object)("exception=" + t));
                    }
                    Util.sleep(300L);
                }
            }
            this.t = null;
        }

        public List getConnectorAddresses() {
            ArrayList<SocketAddress> ret = new ArrayList<SocketAddress>();
            Iterator it = this.connectors.iterator();
            while (it.hasNext()) {
                Connector c = (Connector)it.next();
                ret.add(c.getLocalAddress());
            }
            return ret;
        }

        public void send(DatagramPacket msg) throws Exception {
            if (msg == null) {
                return;
            }
            InetAddress dest = msg.getAddress();
            if (dest == null) {
                throw new IOException("UDP1_4.ConnectorTable.send(): destination address is null");
            }
            if (dest.isMulticastAddress()) {
                for (int i = 0; i < this.connectors.size(); ++i) {
                    ((Connector)this.connectors.get(i)).send(msg);
                }
            } else {
                Connector c = this.pickRandomConnector(this.connectors);
                c.send(msg);
            }
        }

        private Connector pickRandomConnector(Vector conns) {
            int size = conns.size();
            int index = (int)Util.random(size) - 1;
            return (Connector)conns.get(index);
        }

        public void listenOn(String bind_interface, int local_port, int port_range, int receive_buffer_size, int receiver_sock_buf_size, int send_sock_buf_size, int ip_ttl, Receiver receiver) throws IOException {
            if (bind_interface == null) {
                return;
            }
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getByName(bind_interface));
            if (ni == null) {
                throw new IOException("UDP1_4.ConnectorTable.listenOn(): bind interface for " + bind_interface + " not found");
            }
            Connector tmp = this.findConnector(ni);
            if (tmp != null) {
                if (mylog.isWarnEnabled()) {
                    mylog.warn((Object)("connector for interface " + bind_interface + " is already present (will be skipped): " + tmp));
                }
                return;
            }
            if (this.mcast_sock != null) {
                this.mcast_sock.joinGroup(this.mcast_addr, ni);
                if (mylog.isInfoEnabled()) {
                    mylog.info((Object)("joining " + this.mcast_addr + " on interface " + ni));
                }
            }
            tmp = new Connector(ni, local_port, port_range, receive_buffer_size, receiver_sock_buf_size, send_sock_buf_size, ip_ttl, receiver);
            this.connectors.add(tmp);
        }

        private Connector findConnector(NetworkInterface ni) {
            for (int i = 0; i < this.connectors.size(); ++i) {
                Connector c = (Connector)this.connectors.elementAt(i);
                if (!c.getBindInterface().equals(ni)) continue;
                return c;
            }
            return null;
        }

        public void receive(DatagramPacket packet) {
            if (this.receiver != null) {
                this.receiver.receive(packet);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("*** todo: implement ***");
            return sb.toString();
        }

        public static void receivePacket(DatagramPacket packet, DatagramSocket sock, Receiver receiver) throws IOException {
            sock.receive(packet);
            int len = packet.getLength();
            if (len == 1 && packet.getData()[0] == 0) {
                if (mylog.isTraceEnabled()) {
                    mylog.trace((Object)"received dummy packet");
                }
                return;
            }
            if (receiver != null) {
                receiver.receive(packet);
            }
        }
    }

    public static class Connector
    implements Runnable {
        protected Thread t = null;
        protected SenderThread sender_thread = null;
        NetworkInterface bind_interface;
        MulticastSocket mcast_sock = null;
        SocketAddress local_addr = null;
        Receiver receiver = null;
        protected byte[] receive_buffer = null;
        Queue send_queue = new Queue();

        public Connector(NetworkInterface bind_interface, int local_bind_port, int port_range, int receive_buffer_size, int receive_sock_buf_size, int send_sock_buf_size, int ip_ttl, Receiver receiver) throws IOException {
            this.bind_interface = bind_interface;
            this.receiver = receiver;
            this.receive_buffer = new byte[receive_buffer_size];
            this.mcast_sock = this.createMulticastSocket(local_bind_port, port_range);
            this.mcast_sock.setReceiveBufferSize(receive_sock_buf_size);
            this.mcast_sock.setSendBufferSize(send_sock_buf_size);
            this.mcast_sock.setTimeToLive(ip_ttl);
            System.out.println("ttl=" + this.mcast_sock.getTimeToLive());
            this.mcast_sock.setNetworkInterface(this.bind_interface);
            this.local_addr = this.mcast_sock.getLocalSocketAddress();
            System.out.println("-- local_addr=" + this.local_addr);
            System.out.println("-- mcast_sock: send_bufsize=" + this.mcast_sock.getSendBufferSize() + ", recv_bufsize=" + this.mcast_sock.getReceiveBufferSize());
        }

        public SocketAddress getLocalAddress() {
            return this.local_addr;
        }

        public NetworkInterface getBindInterface() {
            return this.bind_interface;
        }

        public void start() throws Exception {
            if (this.mcast_sock == null) {
                throw new Exception("UDP1_4.Connector.start(): connector has been stopped (start() cannot be called)");
            }
            if (this.t != null && this.t.isAlive()) {
                if (mylog.isWarnEnabled()) {
                    mylog.warn((Object)"connector thread is already running");
                }
                return;
            }
            this.t = new Thread((Runnable)this, "ConnectorThread for " + this.local_addr);
            this.t.setDaemon(true);
            this.t.start();
            this.sender_thread = new SenderThread();
            this.sender_thread.start();
        }

        public void stop() {
            if (this.mcast_sock != null) {
                this.mcast_sock.close();
            }
            this.t = null;
            this.mcast_sock = null;
        }

        public void send(DatagramPacket packet) throws Exception {
            byte[] buf = (byte[])packet.getData().clone();
            Object[] arr = new Object[]{buf, packet.getSocketAddress()};
            this.send_queue.add(arr);
        }

        public void run() {
            DatagramPacket packet = new DatagramPacket(this.receive_buffer, this.receive_buffer.length);
            while (this.t != null) {
                try {
                    packet.setData(this.receive_buffer, 0, this.receive_buffer.length);
                    ConnectorTable.receivePacket(packet, this.mcast_sock, this.receiver);
                }
                catch (Throwable t) {
                    if (t == null || this.mcast_sock == null || this.mcast_sock.isClosed()) break;
                    if (mylog.isErrorEnabled()) {
                        mylog.error((Object)("[" + this.local_addr + "] exception=" + t));
                    }
                    Util.sleep(300L);
                }
            }
            this.t = null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("local_addr=").append(this.local_addr).append(", mcast_group=");
            return sb.toString();
        }

        private MulticastSocket createMulticastSocket(int local_bind_port, int port_range) throws IOException {
            int tmp_port;
            MulticastSocket sock = null;
            int max_port = tmp_port + port_range;
            for (tmp_port = local_bind_port; tmp_port <= max_port; ++tmp_port) {
                try {
                    sock = new MulticastSocket(tmp_port);
                    break;
                }
                catch (Exception bind_ex) {
                    continue;
                }
            }
            if (sock == null) {
                throw new IOException("could not create a MulticastSocket (port range: " + local_bind_port + " - " + (local_bind_port + port_range));
            }
            return sock;
        }

        class SenderThread
        extends Thread {
            SenderThread() {
            }

            public void run() {
                while (Connector.this.send_queue != null) {
                    try {
                        Object[] arr = (Object[])Connector.this.send_queue.remove();
                        byte[] buf = (byte[])arr[0];
                        SocketAddress dest = (SocketAddress)arr[1];
                        Connector.this.mcast_sock.send(new DatagramPacket(buf, buf.length, dest));
                    }
                    catch (QueueClosedException e) {
                        break;
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class PacketHandler
    implements Runnable {
        Thread t = null;

        PacketHandler() {
        }

        public void run() {
            while (UDP1_4.this.packet_queue != null && UDP1_4.this.packet_handler != null) {
                SocketAddress sender;
                byte[] data;
                try {
                    Object[] arr = (Object[])UDP1_4.this.packet_queue.remove();
                    data = (byte[])arr[0];
                    sender = (SocketAddress)arr[1];
                }
                catch (QueueClosedException closed_ex) {
                    if (!mylog.isInfoEnabled()) break;
                    mylog.info((Object)"packet_handler thread terminating");
                    break;
                }
                UDP1_4.this.handleIncomingUdpPacket(data, sender);
                data = null;
            }
        }

        void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "UDP1_4.PacketHandler thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (UDP1_4.this.packet_queue != null) {
                UDP1_4.this.packet_queue.close(false);
            }
            this.t = null;
            UDP1_4.this.packet_queue = null;
        }
    }
}

